package com.xdja.poc.common.base;

import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;

/**
 * janus-gateway-android-master
 * 功能 通过scheme传值的可继承这个baseFragment
 * 描述
 * created by Wwq : 2018/9/28
 */

public abstract class UriBaseFragment extends BaseFragment {
    private Uri mUri;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.mUri == null) {
            if (savedInstanceState == null)
                this.mUri = getActivity().getIntent().getData();
            else {
                this.mUri =savedInstanceState.getParcelable("POC_URI");
            }
        }
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (this.mUri != null)
            initFragment(this.mUri);
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        outState.putParcelable("POC_URI", this.mUri);
        super.onSaveInstanceState(outState);
    }

    protected abstract void initFragment(Uri paramUri);
}
