package com.xdja.poc.common.callback;

/**
 * POC-Sdk
 * 功能 异常回调给app处理类
 * 描述
 * created by Wwq : 2018/11/21
 */

public class ExceptionCallBackImpl {
    private static ExceptionCallBackImpl mInstance;
    private IExceptionCallBack iExceptionCallBack;

    public static ExceptionCallBackImpl getmInstance() {
        if (mInstance == null) {
            synchronized (ExceptionCallBackImpl.class) {
                mInstance = new ExceptionCallBackImpl();
            }
        }
        return mInstance;
    }

    public void registerNetCheckCallBack(IExceptionCallBack netCheckCallBack) {
        this.iExceptionCallBack = netCheckCallBack;
    }

    public void notifyNetCheckEvent(Throwable throwable) {
        if (iExceptionCallBack != null) {
            iExceptionCallBack.onCallBack(throwable);
        }
    }

    public interface IExceptionCallBack {
        void onCallBack(Throwable throwable);
    }

}
