package com.xdja.poc.common.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.telephony.TelephonyManager;
import android.util.Log;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author cga
 * @time 2018/9/415:55
 * @des 公共类
 */

public class CommonUtils {
    private static Properties pro;
    private static final String TAG = "CommonUtils";
    private static final String ERROR_PASSWORD_CHAR_REGEX = "[^0-9A-Za-z`~!@#$%^&*()\\-_+=\\[\\]{}\\\\|;:'\",<.>/?]";
    private static final Pattern ERROR_PASSWORD_PATTERN = Pattern.compile(ERROR_PASSWORD_CHAR_REGEX);

    private static final String ERROR_ACCOUNT_CHAR_REGEX = "[^0-9A-Za-z]";
    private static final Pattern ERROR_ACCOUNT_PATTERN = Pattern.compile(ERROR_ACCOUNT_CHAR_REGEX);

    public static boolean checkAccountRegex(String account) {
        return !ERROR_ACCOUNT_PATTERN.matcher(account).find();
    }

    public static boolean checkPasswordRegex(String password) {
        return !ERROR_PASSWORD_PATTERN.matcher(password).find();
    }

    @SuppressLint("MissingPermission")
    public static String getIMEI(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager) context.getSystemService(context.TELEPHONY_SERVICE);
        String imei = telephonyManager.getDeviceId() + 123;
        LogUtils.DLog(TAG, "getIMEI: imei is " + imei);
        return imei;
    }

    public static String getVersionCode(Context context) {
        try {
            PackageManager manager = context.getPackageManager();
            PackageInfo info = manager.getPackageInfo(context.getPackageName(), 0);
            if (info != null) {
                String version = info.versionName;
                return version;
            } else {
                return "";
            }
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    /**
     * 验证手机号码 增加166号段
     *
     * @param cellphone
     * @return
     */
    public static boolean checkCellphone(String cellphone) {
        String regex = "^(13[0-9]|14[579]|15[0-3,5-9]|16[6]|17[0135678]|18[0-9]|19[89])\\d{8}$";
        return check(cellphone, regex);
    }

    /**
     * 验证固话号码
     *
     * @param telephone
     * @return
     */
    public static boolean checkTelephone(String telephone) {
        String regex = "^(0\\d{2}-\\d{8}(-\\d{1,4})?)|(0\\d{3}-\\d{7,8}(-\\d{1,4})?)$";
        return check(telephone, regex);
    }

    private static boolean check(String cellphone, String regex) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(cellphone);
        return m.matches();

    }

    /**
     * 读取assets目录下的properties文件
     *
     * @param context 文件名
     * @param name
     * @return
     */
    public static Properties readProperties(Context context, String name) {
        if (StringUtils.isEmpty(name))
            throw new IllegalArgumentException("Properties name can not null");
        if (pro != null) {
            return pro;
        }
        try {
            pro = new Properties();
            InputStream in = context.getAssets().open(name);
            pro.load(in);
            return pro;
        } catch (Exception e) {
            LogUtils.ELog(e);
        }
        return null;
    }


    /**
     * 检测是否有emoji表情
     *
     * @param source
     * @return
     */
    public static boolean containsEmoji(String source) {
        int len = source.length();
        for (int i = 0; i < len; i++) {
            char codePoint = source.charAt(i);
            if (!isEmojiCharacter(codePoint)) { // 如果不能匹配,则该字符是Emoji表情
                return true;
            }
        }
        return false;
    }

    /**
     * 判断是否是Emoji
     *
     * @param codePoint
     *            比较的单个字符
     * @return
     */
    public static boolean isEmojiCharacter(char codePoint) {
        return (codePoint == 0x0) || (codePoint == 0x9) || (codePoint == 0xA)
                || (codePoint == 0xD)
                || ((codePoint >= 0x20) && (codePoint <= 0xD7FF))
                || ((codePoint >= 0xE000) && (codePoint <= 0xFFFD))
                || ((codePoint >= 0x10000) && (codePoint <= 0x10FFFF));
    }



}