/*
 * {EasyGank}  Copyright (C) {2015}  {CaMnter}
 *
 * This program comes with ABSOLUTELY NO WARRANTY; for details type `show w'.
 * This is free software, and you are welcome to redistribute it
 * under certain conditions; type `show c' for details.
 *
 * The hypothetical commands `show w' and `show c' should show the appropriate
 * parts of the General Public License.  Of course, your program's commands
 * might be different; for a GUI interface, you would use an "about box".
 *
 * You should also get your employer (if you work as a programmer) or school,
 * if any, to sign a "copyright disclaimer" for the program, if necessary.
 * For more information on this, and how to apply and follow the GNU GPL, see
 * <http://www.gnu.org/licenses/>.
 *
 * The GNU General Public License does not permit incorporating your program
 * into proprietary programs.  If your program is a subroutine library, you
 * may consider it more useful to permit linking proprietary applications with
 * the library.  If this is what you want to do, use the GNU Lesser General
 * Public License instead of this License.  But first, please read
 * <http://www.gnu.org/philosophy/why-not-lgpl.html>.
 */

package com.xdja.poc.common.utils;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

@SuppressLint("SimpleDateFormat")

/**
 * janus-gateway-android-master
 * 功能
 * 描述
 * created by Wwq : 2018/9/11
 */
public class DateUtils {

    public static String[] WEEK = new String[]{"天", "一", "二", "三", "四", "五", "六"};

    public static final long ONE_SECOND = 1000;
    public static final long ONE_MINUTE = ONE_SECOND * 60;
    public static final long ONE_HOUR = ONE_MINUTE * 60;
    public static final long ONE_DAY = ONE_HOUR * 24;
    private static String[] weeks = {"第一周", "第二周", "第三周", "第四周", "第五周"};
    private static String[] months = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    /**
     * String 转换 Date
     *
     * @param str    str
     * @param format format
     * @return Date
     */
    public static Date string2Date(String str, String format) {
        try {
            return new SimpleDateFormat(format).parse(str);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return new Date();
    }

    /**
     * 获取日期是星期几
     *
     * @param date
     * @return
     */
    public static String getWeek(Date date) {
        String[] weeks = {"周日", "周一", "周二", "周三", "周四", "周五", "周六"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int week_index = cal.get(Calendar.DAY_OF_WEEK) - 1;
        if (week_index < 0) {
            week_index = 0;
        }
        return weeks[week_index];
    }


    /**
     * 获取日期是星期几
     *
     * @param date
     * @return
     */
    public static String getEngWeek(Date date) {
        String[] weeks = {"Sunday", "Monday ", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int week_index = cal.get(Calendar.DAY_OF_WEEK) - 1;
        if (week_index < 0) {
            week_index = 0;
        }
        return weeks[week_index];
    }


    public static String getWeekNew(Date date) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        //一周第一天是否为星期天
        boolean isFirstSunday = (now.getFirstDayOfWeek() == Calendar.SUNDAY);
        //获取周几
        int weekDay = now.get(Calendar.DAY_OF_WEEK);
        //若一周第一天为星期天,则-1
        if (isFirstSunday) {
            weekDay = weekDay - 1;
            if (weekDay == 0) {
                weekDay = 7;
            }
        }
        String[] weeks = {"星期一", "星期二", "星期三", "星期四", "星期五", "星期六", "星期日"};
        return weeks[weekDay - 1];
    }

    /**
     * String 转 String
     *
     * @param str          str
     * @param format       format
     * @param secondFormat secondFormat
     * @return String
     */
    public static String string2String(String str, String format, String secondFormat) {
        try {
            return date2String(new SimpleDateFormat(format).parse(str).getTime(), secondFormat);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return new Date().toString();
    }


    /**
     * Date（long） 转换 String
     *
     * @param time   time
     * @param format format
     * @return String
     */
    public static String date2String(long time, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(time);
    }


    /**
     * long 去除 时分秒
     * 时分秒全部为0
     *
     * @param date date
     * @return long
     */
    public static long getYearMonthDay(long date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        return calendar.getTimeInMillis();
    }


    /**
     * 获取目标时间和当前时间之间的差距
     *
     * @param date date
     * @return String
     */
    public static String getTimestampString(Date date) {
        Date curDate = new Date();
        long splitTime = curDate.getTime() - date.getTime();
        if (splitTime < (30 * ONE_DAY)) {
            if (splitTime < ONE_MINUTE) {
                return "刚刚";
            }
            if (splitTime < ONE_HOUR) {
                return String.format("%d分钟前", splitTime / ONE_MINUTE);
            }

            if (splitTime < ONE_DAY) {
                return String.format("%d小时前", splitTime / ONE_HOUR);
            }

            return String.format("%d天前", splitTime / ONE_DAY);
        }
        String result;
        result = "M月d日 HH:mm";
        return (new SimpleDateFormat(result, Locale.CHINA)).format(date);
    }

    /**
     * 获取时间,不显示几天前格式
     *
     * @param date date
     * @return String
     */
    public static String generateTimeExculdeDay(Date date) {
        Date curDate = new Date();
        long splitTime = curDate.getTime() - date.getTime();
        if (splitTime < (30 * ONE_DAY)) {
            if (splitTime < ONE_MINUTE) {
                return "刚刚";
            }
            if (splitTime < ONE_HOUR) {
                return String.format("%d分钟前", splitTime / ONE_MINUTE);
            }

            if (splitTime < ONE_DAY) {
                return String.format("%d小时前", splitTime / ONE_HOUR);
            }
        }
        String result;
        result = "MM月dd日 HH:mm";
        return (new SimpleDateFormat(result, Locale.CHINA)).format(date);
    }


    public static String generateDayTime(Date date) {
        return (new SimpleDateFormat("MM月dd日 HH:mm", Locale.CHINA)).format(date);
    }

    /**
     * 24小时制 转换 12小时制
     *
     * @param time time
     * @return String
     */
    public static String time24To12(String time) {
        String str[] = time.split(":");
        int h = Integer.valueOf(str[0]);
        int m = Integer.valueOf(str[1]);
        String sx;
        if (h < 1) {
            h = 12;
            sx = "上午";
        } else if (h < 12) {
            sx = "上午";
        } else if (h < 13) {
            sx = "下午";
        } else {
            sx = "下午";
            h -= 12;
        }
        return String.format("%d:%02d%s", h, m, sx);
    }


    /**
     * Date 转换 HH
     *
     * @param date date
     * @return String
     */
    public static String date2HH(Date date) {
        return new SimpleDateFormat("HH").format(date);
    }

    /**
     * Date 转换 dd
     *
     * @param date date
     * @return String
     */
    public static String date2DD(Date date) {
        return new SimpleDateFormat("dd").format(date);
    }

    /**
     * Date 转换 HH:mm:ss
     *
     * @param date date
     * @return String
     */
    public static String date2HHmm(Date date) {
        return new SimpleDateFormat("HH:mm").format(date);
    }


    /**
     * Date 转换 HH:mm:ss
     *
     * @param date date
     * @return String
     */
    public static String date2HHmmss(Date date) {
        return new SimpleDateFormat("HH:mm:ss").format(date);
    }

    /**
     * Date 转换 MM dd  HH:mm
     *
     * @param date date
     * @return String
     */
    public static String dateMMddhhmm(Date date) {
        return new SimpleDateFormat("MM月dd日 HH:mm").format(date);
    }

    /**
     * Date 转换 MM.dd
     *
     * @param date date
     * @return String
     */
    public static String date2MMdd(Date date) {
        return new SimpleDateFormat("MM.dd").format(date);
    }

    public static String date2MMdd2(Date date) {
        return new SimpleDateFormat("M月d日").format(date);
    }

    public static String time2eekAndDate(long time) {
        return new SimpleDateFormat("M月dd日").format(new Date(time));
    }

    public static String date2MM(Date date) {
        return new SimpleDateFormat("MM").format(date);
    }

    public static String date2yy(Date date) {
        return new SimpleDateFormat("yyyy").format(date).substring(2);
    }

    public static String getTime(Date date) {//可根据需要自行截取数据显示yyyy-MM-dd HH:mm:ss
        SimpleDateFormat format = new SimpleDateFormat("MM");
        return format.format(date);
    }

    public static int getMonthSimple(Date date) {
        String time2 = getTime(date);
        int i = Integer.parseInt(time2);
        return i;
    }

    public static String getTime2(Date date) {//可根据需要自行截取数据显示yyyy-MM-dd HH:mm:ss
        SimpleDateFormat format = new SimpleDateFormat("yyyy");
        String year = format.format(date);
        return year.substring(2);
    }

    public static String getTime3(Date date) {//可根据需要自行截取数据显示yyyy-MM-dd HH:mm:ss
        SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        return format.format(date);
    }

    public static String getDay(Date date) {//可根据需要自行截取数据显示yyyy-MM-dd HH:mm:ss
        SimpleDateFormat format = new SimpleDateFormat("dd");
        return format.format(date);
    }

    public static String getTime4(Date date) {//可根据需要自行截取数据显示yyyy-MM-dd HH:mm:ss
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(date);
    }

    public static String getTime6(Date date) {//可根据需要自行截取数据显示yyyy-MM-dd HH:mm:ss
        SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd");
        return format.format(date);
    }

    public static String getTime5(Date date) {//可根据需要自行截取数据显示yyyy-MM-dd HH:mm:ss
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        return format.format(date);
    }

    /**
     * 计算几天后的日期
     *
     * @param year     年
     * @param month    月
     * @param startDay 初始时间
     * @param days     加几天
     * @return
     */
    public static String getEndDate(int year, int month, int startDay, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, startDay);
        calendar.add(Calendar.DATE, days);
        Date end = calendar.getTime();
        return DateUtils.getTime4(end);
    }

    /**
     * 获取某个月第几周的周一日的期
     *
     * @param year
     * @param month
     * @param week
     * @return
     */
    public static String getStartDate(int year, int month, int week) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, 1);
        int i = 1;
        while (calendar.get(Calendar.DAY_OF_WEEK) != Calendar.MONDAY) {
            calendar.set(Calendar.DAY_OF_MONTH, i++);
        }
        calendar.add(Calendar.DATE, (week - 1) * 7);
        Date time = calendar.getTime();
        return DateUtils.getTime4(time);
    }

    @NonNull
    public static String formatMonth(String time) {
        int i = 0;
        try {
            i = Integer.parseInt(time);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return i + "";
    }

    /**
     * Date 转换 yyyy.MM.dd
     *
     * @param date date
     * @return String
     */

    public static String date2yyyyMM(Date date) {
        return new SimpleDateFormat("yyyyMM").format(date);
    }

    /**
     * Date 转换 MM月dd日 星期
     *
     * @param date date
     * @return String
     */
    public static String date2MMddWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(Calendar.DAY_OF_WEEK);
        return new SimpleDateFormat("MM月dd日 星期").format(date) + WEEK[dayOfWeek - 1];
    }


    /**
     * Date 转换 yyyy年MM月dd日 星期
     *
     * @param date date
     * @return String
     */
    public static String date2yyyyMMddWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(Calendar.DAY_OF_WEEK);
        return new SimpleDateFormat("yyyy年MM月dd日 星期").format(date) + WEEK[dayOfWeek - 1];
    }

    /**
     * Date 转换 yyyy年MM月dd日 星期
     *
     * @param date date
     * @return String
     */
    public static String dateToyyyyMMdd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(Calendar.DAY_OF_WEEK);
        return new SimpleDateFormat("yyyy年MM月dd日").format(date);
    }


    /**
     * 获取某个月最后一天
     *
     * @param year
     * @param month
     * @return
     */
    public static String getLastDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.YEAR, year);
        cal.set(Calendar.MONTH, month - 1);
        cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DATE));
        return new SimpleDateFormat("yyyy-MM-dd").format(cal.getTime());
    }

    /**
     * 获取某个月第一天
     *
     * @param year
     * @param month
     * @return
     */
    public static String getFirstDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.YEAR, year);
        cal.set(Calendar.MONTH, month - 1);
        cal.set(Calendar.DAY_OF_MONTH, cal.getMinimum(Calendar.DATE));
        return new SimpleDateFormat("yyyy-MM-dd").format(cal.getTime());
    }

    public static String getMonthWeek(int week) {
        return weeks[week];
    }

    public static String getTime2Now(String oldTime) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            long old = format.parse(oldTime).getTime();
            long now = System.currentTimeMillis();
            long diff = now - old;//这样得到的差值是微秒级别
            long days = diff / (1000 * 60 * 60 * 24);
            long hours = (diff - days * (1000 * 60 * 60 * 24)) / (1000 * 60 * 60);
            long minutes = (diff - days * (1000 * 60 * 60 * 24) - hours * (1000 * 60 * 60)) / (1000 * 60);
            if (days > 0) {
                return days + "天" + hours + "小时" + minutes + "分";
            } else if (hours > 0) {
                return hours + "小时" + minutes + "分";

            } else {
                return minutes + "分";

            }
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String getWaitTime(String oldTime, String newTime) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            long old = format.parse(oldTime).getTime();
            long now = format.parse(newTime).getTime();
            long diff = now - old;//这样得到的差值是微秒级别
            long days = diff / (1000 * 60 * 60 * 24);
            long hours = (diff - days * (1000 * 60 * 60 * 24)) / (1000 * 60 * 60);
            long minutes = (diff - days * (1000 * 60 * 60 * 24) - hours * (1000 * 60 * 60)) / (1000 * 60);
            if (days > 0) {
                return days + "天" + hours + "小时" + minutes + "分";
            } else if (hours > 0) {
                return hours + "小时" + minutes + "分";

            } else {
                return minutes + "分";

            }
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String getYesterday(Date date) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.add(Calendar.DATE, -1);
        return getTime4(instance.getTime());
    }

    public static String formateTime(int time) {
        long hour = (long) (time / 3600);
        long minute = ((long) time - hour * 60L * 60L) / 60L;
        long second = (long) time - hour * 60L * 60L - minute * 60L;
        String sh = "";
        String sm = "";
        String ss = "";
        if (hour < 10L) {
            sh = "0" + String.valueOf(hour);
        } else {
            sh = String.valueOf(hour);
        }

        if (minute < 10L) {
            sm = "0" + String.valueOf(minute);
        } else {
            sm = String.valueOf(minute);
        }

        if (second < 10L) {
            ss = "0" + String.valueOf(second);
        } else {
            ss = String.valueOf(second);
        }
        return sh + ":" + sm + ":" + ss;
    }

    public static String getMonthEng(Date date) {
        String month = getTime(date);
        int i = Integer.parseInt(month);
        return months[i - 1];
    }

    public static boolean isToday(Date day) {
        Calendar pre = Calendar.getInstance();
        Date predate = new Date(System.currentTimeMillis());
        pre.setTime(predate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(day);
        if (cal.get(Calendar.YEAR) == (pre.get(Calendar.YEAR))) {
            int diffDay = cal.get(Calendar.DAY_OF_YEAR)
                    - pre.get(Calendar.DAY_OF_YEAR);

            if (diffDay == 0) {
                return true;
            }
        }
        return false;
    }

    public static String getTime7(long start, long end) {
        Date startDate = new Date(start);
        Date endDate = new Date(end);
        String s = "" + getTime(startDate) + "/" + getDay(startDate) +
                "-" +
                getTime(endDate) + "/" + getDay(endDate);
        return s;
    }

    public static String getFormatedPassedTime(long createTime) {
        long differentMilliSeconds = System.currentTimeMillis() - createTime;
        long secondsInMilli = 1000;//1s==1000ms
        long minutesInMilli = secondsInMilli * 60;
        long hoursInMilli = minutesInMilli * 60;

        long elapsedSeconds = differentMilliSeconds / secondsInMilli;
        if (elapsedSeconds <= 60) {
            return "刚刚";
        }
        long elapsedMinutes = differentMilliSeconds / minutesInMilli;
        if (elapsedSeconds <= 3600) {
            return elapsedMinutes + "分钟前";
        }
        long elapsedHours = differentMilliSeconds / hoursInMilli;
        if (elapsedMinutes <= 1440) {
            return elapsedHours + "小时前";
        }
        DateFormat format = new SimpleDateFormat("M月dd日 HH:mm");
        return format.format(new Date(createTime));
    }
}