package com.xdja.poc.common.utils;

import android.util.Log;

import com.xdja.poc.common.callback.ExceptionCallBackImpl;

/**
 * Created by Administrator on 2018/8/27.
 */

public class LogUtils {
    public static boolean isOpen = true;
    private static String TAG = "POC_LOG";

    public static void ELog(Throwable t) {
        ExceptionCallBackImpl.getmInstance().notifyNetCheckEvent(t);
        if (isOpen) {
            if (t != null)
                Log.e(TAG, "[POC_LOG]  " + "[" + Thread.currentThread().getName() + "]:在" + t.getStackTrace()[0].getClassName() + " " + t.getLocalizedMessage());
        }
    }

    public static void DLog(Throwable t) {
        if (isOpen) {
            if (t != null)
                Log.d(TAG, "[POC_LOG]  " + "[" + Thread.currentThread().getName() + "]:在" + t.getStackTrace()[0].getClassName());
        }
    }

    public static void WLog(Throwable t) {
        if (isOpen) {
            if (t != null)
                Log.w(TAG, "[POC_LOG]  " + "[" + Thread.currentThread().getName() + "]:在" + t.getStackTrace()[0].getClassName());
        }
    }

    public static void ILog(Throwable t) {
        if (isOpen) {
            if (t != null)
                Log.i(TAG, "[POC_LOG]  " + "[" + Thread.currentThread().getName() + "]:在" + t.getStackTrace()[0].getClassName());
        }
    }

    public static void ELog(String tag, String message) {
        if (isOpen) {
            Log.e(tag, "[POC_LOG]  " + message);
        }
    }

    public static void DLog(String tag, String message) {
        if (isOpen) {
            Log.d(tag, "[POC_LOG]  " + message);
        }
    }

    public static void WLog(String tag, String message) {
        if (isOpen) {
            Log.w(tag, "[POC_LOG]  " + message);
        }
    }

    public static void ILog(String tag, String message) {
        if (isOpen) {
            Log.i(tag, "[POC_LOG]  " + message);
        }
    }

    public static void ILog(String message) {
        if (isOpen) {
            Log.i("POC_LOG", "[POC_LOG]  " + message);
        }
    }
}
