package com.xdja.poc.common.utils;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

/**
 * @author liweijun 2012-09-30 编写
 *         获取汉语拼音和首字母
 */
public class PinyinUtil {

    /**
     * 得到 全拼
     *
     * @param src
     * @return
     */
    public static String getPingYin(String src) {
        char[] t1;
        if (src == null) {
            return "#";
        }
        t1 = src.toCharArray();
        String[] t2 = new String[t1.length];
        HanyuPinyinOutputFormat t3 = new HanyuPinyinOutputFormat();
        t3.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        t3.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        t3.setVCharType(HanyuPinyinVCharType.WITH_U_UNICODE);
        StringBuffer t4 = new StringBuffer();
        int t0 = t1.length;
        try {
            for (int i = 0; i < t0; i++) {
                // 判断是否为汉字字符
                if (Character.toString(t1[i]).matches(
                        "[\\u4E00-\\u9FA5]+")) {
                    t2 = PinyinHelper.toHanyuPinyinStringArray(t1[i], t3);
                    if (t2 != null) {
                        t4.append(t2[0]);
                    }
                    //t4 += t2[0];
                } else {
                    //t4 += Character.toString(t1[i]);
                    t4.append(Character.toString(t1[i]));
                }
            }
            return t4.toString();
        } catch (BadHanyuPinyinOutputFormatCombination e1) {
            e1.printStackTrace();
        }
        return t4.toString();
    }

    /**
     * 得到中文首字母
     *
     * @param str
     * @return
     */
    public static String getPinYinHeadChar(String str) {

        StringBuffer convert = new StringBuffer();
        for (int j = 0; j < str.length(); j++) {
            char word = str.charAt(j);
            String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray(word);
            if (pinyinArray != null) {
                //convert += pinyinArray[0].charAt(0);
                convert.append(pinyinArray[0].charAt(0));
            } else {
                //convert += word;
                convert.append(word);
            }
        }
        return convert.toString();
    }

    /**
     * 将字符串转移为ASCII码
     *
     * @param cnStr
     * @return
     */
    public static String getCnASCII(String cnStr) {
        try {
            StringBuffer strBuf = new StringBuffer();
            byte[] bGBK = cnStr.getBytes("GBK");
            for (int i = 0; i < bGBK.length; i++) {
                // System.out.println(Integer.toHexString(bGBK[i]&0xff));
                strBuf.append(Integer.toHexString(bGBK[i] & 0xff));
            }
            return strBuf.toString();
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 获取汉字串拼音首字母,英文字符不变
     *
     * @param chinese 汉字串
     * @return 汉语拼音首字母
     */
    public static String getFirstSpell(String chinese) {
        if (chinese == null) {
            return "#";
        }
        StringBuffer pybf = new StringBuffer();
        char[] arr = chinese.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < arr.length; i++) {
            if (arr[i] > 128) {
                try {
                    String[] temp = PinyinHelper.toHanyuPinyinStringArray(arr[i], defaultFormat);
                    if (temp != null) {
                        pybf.append(temp[0].charAt(0));
                    }
                } catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
            } else {
                pybf.append(arr[i]);
            }
        }
        return pybf.toString().replaceAll("\\W", "").trim();
    }

    /**
     * 获取汉字串拼音,英文字符不变
     *
     * @param chinese 汉字串
     * @return 汉语拼音
     */
    public static String getFullSpell(String chinese) {
        if(chinese==null){
            return "#";
        }
        StringBuffer pybf = new StringBuffer();
        char[] arr = chinese.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < arr.length; i++) {
            if (arr[i] > 128) {
                try {
                    pybf.append(PinyinHelper.toHanyuPinyinStringArray(arr[i], defaultFormat)[0]);
                } catch (Exception e) {
                    e.printStackTrace();
                    pybf.append(arr[i]);
                }
            } else {
                pybf.append(arr[i]);
            }
        }
        return pybf.toString();
    }

    public static String[] getFullSpellArray(String chinese) {
        String[] defaultResult = new String[1];
        defaultResult[0] = chinese;
        if(chinese==null){
            return defaultResult;
        }
        char[] arr = chinese.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < arr.length; i++) {
            if (arr[i] > 128) {
                try {
                    String[] result = PinyinHelper.toHanyuPinyinStringArray(arr[i], defaultFormat);
                    return result;
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return defaultResult;
    }

    /**
     * 匹配字母 数字 下划线 中文  中英文标点符号
     *
     * @return
     */
//	public static boolean checkStringRule(String str){
//		if(str.matches("^[A-Za-z0-9\\u4E00-\\u9FA5\\uFF20\\uFF5E`~!@#\\$%\\^\\*\\(\\)\\-_=+\\[\\{\\]\\};:'\",<\\.>/\\?’！#￥%……*（）——+-=\\{\\}【】、,。/“;:《》？]*$")){
//			return true;
//		}else{
//			return false;
//		}
//	}
    public static String getLetterChar(String content) {
        if (!StringUtils.isEmpty(content)) {
            String pingYin = PinyinUtil.getPingYin(content);
            if (!StringUtils.isEmpty(pingYin)) {
                String sortString = pingYin.substring(0, 1).toUpperCase();
                if (sortString.matches("[A-Z]")) {
                    return sortString;
                }
            }
        }
        return "#";
    }

}