package com.xdja.poc.common.utils;

import android.content.Context;
import android.content.SharedPreferences;

import java.util.Set;

/**
 * janus-gateway-android-master
 * 功能  sharePreference 操作类
 * 描述
 * created by Wwq : 2018/8/31
 */

public class PreferenceHelper {
    private static SharedPreferences getSharedPreference(Context context) {
        return context.getSharedPreferences("poc_sp", Context.MODE_MULTI_PROCESS);
    }
    public static String getString(String key, String defValue) {
        return getSharedPreference(GlobalContext.getContext()).getString(key, defValue);
    }

    public static int getInt(String key, int defValue) {
        return getSharedPreference(GlobalContext.getContext()).getInt(key, defValue);
    }

    public static long getLong(String key, long defValue) {
        return getSharedPreference(GlobalContext.getContext()).getLong(key, defValue);
    }

    public static boolean getBoolean(String key, boolean defValue) {
        return getSharedPreference(GlobalContext.getContext()).getBoolean(key, defValue);
    }

    public static float getFloat(String key, float defValue) {
        return getSharedPreference(GlobalContext.getContext()).getFloat(key, defValue);
    }

    public static void setString(String key, String value) {
        getSharedPreference(GlobalContext.getContext()).edit().putString(key, value).apply();
    }

    public static void setInt(String key, int value) {
        getSharedPreference(GlobalContext.getContext()).edit().putInt(key, value).apply();
    }

    public static void setLong(String key, long value) {
        getSharedPreference(GlobalContext.getContext()).edit().putLong(key, value).apply();
    }

    public static void setFloat(String key, float value) {
        getSharedPreference(GlobalContext.getContext()).edit().putFloat(key, value).apply();
    }

    public static void setBoolean(String key, boolean value) {
        getSharedPreference(GlobalContext.getContext()).edit().putBoolean(key, value).apply();
    }

    public static void setStringSet(String key, Set<String> value) {
        getSharedPreference(GlobalContext.getContext()).edit().putStringSet(key, value).apply();
    }

    public static Set<String> getStringSet(String key, Set<String> value) {
        return getSharedPreference(GlobalContext.getContext()).getStringSet(key, value);
    }
}
