package com.xdja.poc.common.utils;

import android.content.Context;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;

import com.xdja.poc.common.R;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * janus-gateway-android-master
 * Administrator
 * 2018/8/27
 */

public class StringUtils {
    /**
     * 判断string是否为空
     *
     * @param content
     * @return
     */
    public static boolean isEmpty(String content) {
        if (TextUtils.isEmpty(content)) {
            return true;
        }
        return false;
    }

    /**
     * 统一对空字符串/空指针做处理
     *
     * @param content
     * @return
     */
    public static String generateContent(String content) {
        if (TextUtils.isEmpty(content)) {
            return "";
        }
        return content;
    }

    /**
     * 将关键字在nameOrNumber中高亮显示,返回spanned
     *
     * @param nameOrNumber
     * @param searchKey
     * @param context
     * @return
     */
    public static Spanned getSpanned(String nameOrNumber, String searchKey, Context context) {
        if (StringUtils.isEmpty(nameOrNumber)) {
            return Html.fromHtml(nameOrNumber);
        }
        if (StringUtils.isEmpty(searchKey)) {
            return Html.fromHtml(nameOrNumber);
        }
        int index = nameOrNumber.indexOf(searchKey);
        if (index == -1) {
            return Html.fromHtml(nameOrNumber);
        }
        int keyLength = searchKey.length();
        String start = nameOrNumber.substring(0, index);
        String middle = nameOrNumber.substring(index, index + keyLength);
        String end = nameOrNumber.substring(index + keyLength, nameOrNumber.length());
        StringBuffer sb = new StringBuffer();
        sb.append(TextUtils.htmlEncode(start));
        sb.append("<font color = ");
        sb.append(context.getResources().getColor(R.color.common_main_color));
        sb.append(">");
        sb.append(TextUtils.htmlEncode(middle));
        sb.append("</font>");
        sb.append(TextUtils.htmlEncode(end));
        String s = sb.toString();
        return Html.fromHtml(s);
    }

    /**
     * 截取名称前size个字符 后加 ...
     * @param size 截取的长度
     * @param userName
     * @return
     */
    public static String splitDisplayName(int size,String userName) {
        if (StringUtils.isEmpty(userName)) {
            return "";
        }
        String substring = "";
        if (userName.length() > size) {
            substring = userName.substring(0, size) + "...";
        } else {
            substring = userName;
        }
        return substring;
    }

    /**
     *
     * @param content
     * @return
     */
    public static boolean filterSpecialChar(String content){
        String regEx = "[{}\\[\\]<>【】”“\"]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(content);
        return m.find();
    }
}
