package com.xdja.poc.common.utils;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import com.xdja.poc.common.R;
import com.xdja.poc.common.base.BaseActivity;

/**
 * Created by Administrator on 2018/8/24.
 */

public class ToastUtils {
    private Toast toast;
    private static String TAG = "ToastUtils";
    private TextView tv;

    public static void initToast() {
        if (UiUtils.isMainThread()) {
            ToastUtils.SingletonHolder.sInstance.init();
        } else {
            LogUtils.ELog(TAG, "toast must show on Main Thread");
        }
    }

    private void init() {
        //toast = Toast.makeText(mContext, "", Toast.LENGTH_SHORT);
        toast = new Toast(GlobalContext.getContext());
        toast.setDuration(Toast.LENGTH_LONG);
        LayoutInflater inflate = (LayoutInflater)
                GlobalContext.getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View v = inflate.inflate(R.layout.common_toast_layout, null);
        tv = (TextView) v.findViewById(R.id.message);
        toast.setView(v);
    }

    /**
     * 不按顺序,弹出当前该弹出的toast
     *
     * @param message
     */
    public static void showToast(String message) {
        if (UiUtils.isMainThread()&& BaseActivity.isSelfActivity) {
            ToastUtils.SingletonHolder.sInstance.show(message);
        } else {
            LogUtils.ELog(TAG, "toast must show on Main Thread");
        }

    }

    /**
     * 按顺序弹出toast
     */
    public static void showQueneToast(String message) {
        if (UiUtils.isMainThread()&& BaseActivity.isSelfActivity) {
            ToastUtils.SingletonHolder.sInstance.showQueneToast_(message);
        } else {
            LogUtils.ELog(TAG, "toast must show on Main Thread");
        }

    }

    /**
     * 取消toast
     */
    public static void cancleToast() {
        if (UiUtils.isMainThread()) {
            ToastUtils.SingletonHolder.sInstance.cancle();
        } else {
            LogUtils.ELog(TAG, "toast must show on Main Thread");
        }
    }

    private void showQueneToast_(String message) {
        if (UiUtils.isMainThread()) {
            Toast.makeText(GlobalContext.getContext(), "" + message, Toast.LENGTH_SHORT).show();
        } else {
            LogUtils.ELog(TAG, "toast must show on Main Thread");
        }

    }

    private void show(String message) {
        if (toast != null) {
            //toast.setText(message);
            tv.setText(message);
            toast.setDuration(Toast.LENGTH_LONG);
            toast.show();
        }
    }

    private void cancle() {
        if (toast != null) {
            toast.cancel();
        } else {
            LogUtils.ELog(TAG, "toast must show on Main Thread");
        }
    }

    private static class SingletonHolder {
        static ToastUtils sInstance = new ToastUtils();

    }
}
