package com.xdja.poc.common.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.view.View;
import android.view.inputmethod.InputMethodManager;

/**
 * janus-gateway-android-master
 * Administrator
 * 2018/8/27
 */

public class UiUtils {
    public static boolean isMainThread() {
        return Thread.currentThread().getName().equals("main");
    }

    public static String getCurrentProcessName(Context context) {
        int myPid = android.os.Process.myPid();
        ActivityManager am = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        for (ActivityManager.RunningAppProcessInfo appProcess : am.getRunningAppProcesses()) {
            if (appProcess.pid == myPid) {
                return appProcess.processName;
            }
        }
        return null;
    }

    /**
     * 隐藏键盘
     *
     * @param context
     */
    public static void hideKeyBoard(Context context,View view) {
        InputMethodManager imm = (InputMethodManager) context.getSystemService(Context.INPUT_METHOD_SERVICE);
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    /**
     * 弹出键盘
     *
     * @param context
     */
    public static void showKeyBoard(Context context) {
        InputMethodManager imm = (InputMethodManager) context.getSystemService(Context.INPUT_METHOD_SERVICE);
        if (!imm.isActive()) {
            imm.toggleSoftInput(0, InputMethodManager.HIDE_NOT_ALWAYS);
        }
    }
}

