package com.xdja.poc.common.utils;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.IdRes;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.DrawableTypeRequest;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.drawable.GlideDrawable;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SimpleTarget;
import com.xdja.poc.common.R;
import com.xdja.poc.common.view.GrayCircleImageTransformation;

/**
 * janus-gateway-android-master
 * Administrator
 * 2018/8/27
 */

public class ViewUtils {

    /**
     * 不带有默认图片设置
     *
     * @param context
     * @param view
     * @param path
     */
    public static void intoView(Context context, ImageView view, String path) {
        Glide.with(context).load(path).diskCacheStrategy(DiskCacheStrategy.ALL).into(view);
    }

    /**
     * 带有默认图片设置
     *
     * @param context
     * @param view
     * @param id
     * @param path
     */
    public static void intoView(Context context, ImageView view, @DrawableRes int id, String path) {
        Glide.with(context).load(path).placeholder(id).diskCacheStrategy(DiskCacheStrategy.ALL).error(id).into(view);
    }

    /**
     * textView赋值,做了空处理
     *
     * @param textView
     * @param content
     */
    public static void intoTextView(TextView textView, String content) {
        textView.setText(StringUtils.generateContent(content));
    }

    public static void loadCircleBitmap(Context context, final String path, View view, int defaultRes, boolean isGray) {
        DrawableTypeRequest<String> drawableTypeRequest = Glide.with(context).load(path);
        drawableTypeRequest.bitmapTransform(new GrayCircleImageTransformation(context, isGray));
        if (isGray) {
            drawableTypeRequest.skipMemoryCache(true);
            drawableTypeRequest.diskCacheStrategy(DiskCacheStrategy.NONE);
        }
        if (defaultRes != -1) {
            drawableTypeRequest.placeholder(defaultRes);
        }
        if (isGray) {
            drawableTypeRequest.skipMemoryCache(true);
            drawableTypeRequest.diskCacheStrategy(DiskCacheStrategy.NONE);
        }
        view.setTag(R.id.common_item_image_url, path);
        drawableTypeRequest.into(new SimpleTarget<GlideDrawable>() {
            @Override
            public void onResourceReady(GlideDrawable glideDrawable, GlideAnimation<? super GlideDrawable> glideAnimation) {
                Object obj = view.getTag(R.id.common_item_image_url);
                if (null == obj) {
                    return;
                }
                String url = (String) obj;
                if (url.equals(path)) {
                    if (view instanceof TextView) {
                        view.setBackground(glideDrawable);
                    } else if (view instanceof ImageView) {
                        ((ImageView) view).setImageDrawable(glideDrawable);
                    }
                }

            }

            @Override
            public void onLoadFailed(Exception e, Drawable errorDrawable) {
                if (view instanceof TextView) {
                    view.setBackgroundResource(defaultRes);
                } else if (view instanceof ImageView) {
                    ((ImageView) view).setImageResource(defaultRes);
                }
                super.onLoadFailed(e, errorDrawable);
            }
        });
    }

}
