package com.xdja.poc.common.view;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.xdja.poc.common.R;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.ViewUtils;

/**
 * janus-gateway-android-master
 * 功能
 * 描述
 * created by Wwq : 2018/9/26
 */

public class EmptyView extends LinearLayout implements IEmptyView {
    private ImageView ivIcon;
    private TextView tvConent;
    private LinearLayout llEmptyConent;

    public EmptyView(Context context) {
        this(context, null);
    }

    public EmptyView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EmptyView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater layoutInflater = LayoutInflater.from(getContext());
        View view = layoutInflater.inflate(R.layout.common_emty_view, this, false);
        addView(view, new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT,
                RelativeLayout.LayoutParams.MATCH_PARENT));
        ivIcon = findViewById(R.id.iv_icon);
        tvConent = findViewById(R.id.tv_content);
        llEmptyConent = view.findViewById(R.id.ll_empty_content);
    }

    @Override
    public void init(Configure configure, ISpanClickListener listener) {
        if (configure == null) {
            throw new IllegalArgumentException("empty configure is can't null");
        }
        ivIcon.setBackgroundResource(configure.iconId);
        ViewUtils.intoTextView(tvConent, configure.content);
        if (!StringUtils.isEmpty(configure.clickContent)) {
            SpannableString clickString = new SpannableString(" " + configure.clickContent + " ");
            clickString.setSpan(new ClickableSpan() {
                @Override
                public void onClick(View widget) {
                    if (listener != null) {
                        listener.onClick();
                    }
                }

                @Override
                public void updateDrawState(TextPaint ds) {
                    super.updateDrawState(ds);
                    ds.setColor(configure.clickColor);//设置颜色
                    ds.setUnderlineText(false);
                }
            }, 0, clickString.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
            tvConent.append(clickString);
            tvConent.setMovementMethod(LinkMovementMethod.getInstance());
        }
        tvConent.append(StringUtils.isEmpty(configure.spanString) ? "" : configure.spanString);

    }

    public LinearLayout getContentView() {
        return llEmptyConent;
    }

    public interface ISpanClickListener {
        void onClick();
    }

    public static class Configure {
        private int iconId;//图标id
        private int clickColor;//可点击的文字的颜色
        private String content;//可点击文字前部分的文字
        private String clickContent;//可点击的文字
        private String spanString;//可点击文字后面的内容

        public Configure(int iconId, int clickColor, String content, String clickContent, String spanString) {
            this.iconId = iconId;
            this.clickColor = clickColor;
            this.content = content;
            this.clickContent = clickContent;
            this.spanString = spanString;
        }

        public static class Builder {
            private int iconId;
            private int clickColor;
            private String content;
            private String clickContent;
            private String spanString;

            public Configure build() {
                return new Configure(iconId, clickColor, content, clickContent, spanString);
            }

            public Builder setIconId(int iconId) {
                this.iconId = iconId;
                return this;
            }


            public Builder setClickColor(int clickColor) {
                this.clickColor = clickColor;
                return this;
            }

            public Builder setContent(String content) {
                this.content = content;
                return this;
            }

            public Builder setClickContent(String clickContent) {
                this.clickContent = clickContent;
                return this;
            }

            public Builder setSpanString(String spanString) {
                this.spanString = spanString;
                return this;
            }
        }
    }
}
