package com.xdja.poc.common.view;


import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;

public class GrayCircleImageTransformation implements Transformation<Bitmap> {
    private BitmapPool bitmapPool;
    private boolean isGray;
    private ColorMatrixColorFilter grayColorFilter;

    public GrayCircleImageTransformation(Context context) {
        this(context, false);
    }

    public GrayCircleImageTransformation(Context context, boolean isGray) {
        this.bitmapPool = Glide.get(context).getBitmapPool();
        ColorMatrix colorMatrix = new ColorMatrix();
        colorMatrix.setSaturation(0);
        grayColorFilter = new ColorMatrixColorFilter(colorMatrix);
        this.isGray = isGray;

    }

    @Override
    public Resource<Bitmap> transform(Resource<Bitmap> resource, int i, int i1) {
        Bitmap source = resource.get();
        int size = Math.min(source.getWidth(), source.getHeight());

        int width = (source.getWidth() - size) / 2;
        int height = (source.getHeight() - size) / 2;

        Bitmap bitmap = bitmapPool.get(size, size, Bitmap.Config.ARGB_8888);
        if (bitmap == null) {
            bitmap = Bitmap.createBitmap(size, size, Bitmap.Config.ARGB_8888);
        }

        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        BitmapShader shader =
                new BitmapShader(source, BitmapShader.TileMode.CLAMP, BitmapShader.TileMode.CLAMP);
        if (width != 0 || height != 0) {
            // source isn't square, move viewport to center
            Matrix matrix = new Matrix();
            matrix.setTranslate(-width, -height);
            shader.setLocalMatrix(matrix);
        }
        paint.setShader(shader);
        paint.setAntiAlias(true);
        if(isGray) {
            paint.setColorFilter(grayColorFilter);
        }
        float r = size / 2f;
        canvas.drawCircle(r, r, r, paint);

        return BitmapResource.obtain(bitmap, bitmapPool);
    }

    @Override
    public String getId() {
        return "GrayCircleImageTransformation";
    }

    public void setGray(boolean isGray) {
        this.isGray = isGray;
    }
}
