package com.xdja.poc.common.view;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.xdja.poc.common.R;
import com.xdja.poc.common.utils.DisplayUtil;

/**
 * POC-Sdk
 * 功能
 * 描述
 * created by Wwq : 2018/11/24
 */

public class ListMoreLoadView extends LinearLayout {
    private TextView tvDescContent;

    public ListMoreLoadView(Context context) {
        this(context, null);
    }

    public ListMoreLoadView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ListMoreLoadView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater layoutInflater = LayoutInflater.from(getContext());
        View view = layoutInflater.inflate(R.layout.common_list_more_view, this, false);
        addView(view, new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT,
                DisplayUtil.dip2px(getContext(),45)));
        tvDescContent = view.findViewById(R.id.tv_desc_content);
    }

    public void setDescContent(String content) {
        tvDescContent.setText(content);
    }

    public TextView getTvDescContent() {
        return tvDescContent;
    }

    public void setViewHeight(int height) {
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, height);
        this.setLayoutParams(layoutParams);
    }
}
