package com.xdja.poc.common.view;

import android.content.Context;
import android.text.InputFilter;
import android.text.Spanned;
import android.util.AttributeSet;
import android.widget.EditText;

import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.ToastUtils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * POC-Sdk
 * 功能
 * 描述
 * created by Wwq : 2018/11/17
 */

public class NoEmojEditText extends EditText {

    public NoEmojEditText(Context context) {
        super(context);
    }

    public NoEmojEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public NoEmojEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setIsFavorEmoj(boolean isFavor, String tips) {
        if (!isFavor) {
            this.setFilters(new InputFilter[]{new InputFilter() {
                Pattern emoji = Pattern.compile("[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\u2600-\u27ff]",
                        Pattern.UNICODE_CASE | Pattern.CASE_INSENSITIVE);

                @Override
                public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
                    Matcher emojiMatcher = emoji.matcher(source);
                    if (emojiMatcher.find()) {
                        //                    Toast.makeText(MainActivity.this,"不支持输入表情", 0).show();
                        ToastUtils.showToast(StringUtils.isEmpty(tips) ? "不支持输入表情" : tips);
                        return "";
                    }
                    return null;
                }
            }});
        }
    }
}
