package com.xdja.poc.common.view;

import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.IdRes;
import android.support.annotation.Nullable;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;

import com.xdja.poc.common.R;
import com.xdja.poc.common.utils.LogUtils;

/**
 * janus-gateway-android-master
 * 功能  搜索框SearchEditView
 * 描述
 * created by Wwq : 2018/8/29
 */

public class SearchEditView extends LinearLayout implements ISearchView {
    private String TAG = "SearchEditView";
    private NoEmojEditText etSearch;
    private ImageView ivClear;
    private ISearchCallBack mSearchCallBack;
    private Context mContext;
    public SearchEditView(Context context) {
        this(context, null);
        mContext = context;
    }

    public SearchEditView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
        mContext = context;
    }

    public SearchEditView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        mContext = context;
        LayoutInflater layoutInflater = LayoutInflater.from(getContext());
        View view = layoutInflater.inflate(R.layout.common_search_editview, this, false);
        addView(view, new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT,
                RelativeLayout.LayoutParams.WRAP_CONTENT));
        etSearch = $(view, R.id.et_search);
        ivClear = $(view, R.id.iv_clear);
        ivClear.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                etSearch.setText("");
            }
        });
        etSearch.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                etSearch.setFocusable(true);
                etSearch.setFocusableInTouchMode(true);
                etSearch.requestFocus();
                etSearch.findFocus();
                showKeyBoard();
            }
        });
    }

    private <T extends View> T $(View view, @IdRes int id) {
        return view.findViewById(id);
    }

    @Override
    public EditText getEditText() {
        return etSearch;
    }

    @Override
    public void setSHintText(String text) {
        etSearch.setHint(text);
    }

    @Override
    public void setSHintColor(@ColorInt int color) {
        etSearch.setHintTextColor(color);
    }

    @Override
    public void setIsFavorEmoj(boolean isFavor,String tips) {
        etSearch.setIsFavorEmoj(isFavor,tips);
    }

    @Override
    public void startSearch(String keyWords) {

    }

    @Override
    public void addTextChangeWatcher(TextWatcher textWatcher) {
        etSearch.addTextChangedListener(textWatcher);
    }

    @Override
    public void addTextChangeWatcher(ISearchCallBack callBack) {
        this.mSearchCallBack = callBack;
        etSearch.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable key) {
                if (mSearchCallBack != null) {
                    String keyWord = key.toString();
                    if (TextUtils.isEmpty(keyWord)) {
                        ivClear.setVisibility(View.GONE);
                        mSearchCallBack.onEndSearch();
                    } else {
                        ivClear.setVisibility(View.VISIBLE);
                        mSearchCallBack.onStartSearch(keyWord);
                    }
                } else {
                    LogUtils.WLog(TAG, "must set text changed callback:addTextChangeWatcher ");
                }
            }
        });
    }

    public void clear() {
        etSearch.setText("");
        etSearch.setFocusable(false);
    }

    public void closeKeyboard() {
        InputMethodManager imm = (InputMethodManager) mContext.getSystemService(Context.INPUT_METHOD_SERVICE);
        imm.hideSoftInputFromWindow(etSearch.getWindowToken(), 0);
        etSearch.setFocusable(false);
    }

    private void showKeyBoard() {
        InputMethodManager imm = (InputMethodManager) mContext.getSystemService(Context.INPUT_METHOD_SERVICE);
        imm.showSoftInput(etSearch, InputMethodManager.SHOW_FORCED);
    }
}
