package com.xdja.poc.common.view;

import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.IdRes;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.xdja.poc.common.R;
import com.xdja.poc.common.utils.DisplayUtil;
import com.xdja.poc.common.utils.StringUtils;

/**
 * janus-gateway-android-master
 * 功能  通用的titlebarView
 * 描述  可设置不同的属性,慢慢迭代、适配
 * created by Wwq : 2018/8/29
 */

public class TitleBarView extends LinearLayout implements ITitleBar {
    private ImageView ivLeftBack;
    private ImageView ivRightView;
    private TextView tvTitle, tvRight;
    private View viewLine;
    private RelativeLayout rlTitlebg;
    private View lineView;
    private View redPoint;
    private ImageView ivLeftSecond;

    public TitleBarView(Context context) {
        this(context, null);
    }

    public TitleBarView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TitleBarView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater layoutInflater = LayoutInflater.from(getContext());
        View view = layoutInflater.inflate(R.layout.common_tiltebar_view, this, false);
        addView(view, new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT,
                RelativeLayout.LayoutParams.WRAP_CONTENT));
        ivLeftBack = $(view, R.id.iv_left);
        ivRightView = $(view, R.id.iv_right);
        tvTitle = $(view, R.id.tv_title);
        viewLine = $(view, R.id.view_line);
        rlTitlebg = $(view, R.id.rl_title_bg);
        tvRight = $(view, R.id.tv_right);
        redPoint = findViewById(R.id.poc_red_point);
        ivLeftSecond = findViewById(R.id.iv_new_message);
        lineView = findViewById(R.id.view_line);

    }

    private <T extends View> T $(View view, @IdRes int id) {
        return view.findViewById(id);
    }

    @Override
    public void setBackgroundRecource(@ColorRes int resid) {
        rlTitlebg.setBackgroundResource(resid);
    }

    public void setRightText(String right) {
        if (!TextUtils.isEmpty(right)) {
            ivRightView.setVisibility(GONE);
            tvRight.setVisibility(VISIBLE);
            tvRight.setText(right);
        } else {
            ivRightView.setVisibility(GONE);
            tvRight.setVisibility(GONE);
        }
    }

    public void setRightTextColor(@ColorInt int color) {
        tvRight.setTextColor(color);
    }

    public void setRightTextSize(float size) {
        tvRight.setTextSize(size);
    }

    @Override
    public void setTile(String title) {
        tvTitle.setText(StringUtils.generateContent(title));
        tvTitle.setVisibility(VISIBLE);
    }

    @Override
    public void setTextSize(int size) {
        tvTitle.setTextSize(TypedValue.COMPLEX_UNIT_SP, size);
    }

    @Override
    public void setTitleColor(@ColorInt int colorId) {
        tvTitle.setTextColor(colorId);
    }

    @Override
    public void setLeftViewRecource(@DrawableRes int resid) {
        ivLeftBack.setBackgroundResource(resid);
        ivLeftBack.setVisibility(VISIBLE);
    }

    @Override
    public void setRightViewRecource(@DrawableRes int resid) {
        ivRightView.setBackgroundResource(resid);
        ivRightView.setVisibility(VISIBLE);
        tvRight.setVisibility(GONE);
    }

    @Override
    public void setLeftViewClickListener(View.OnClickListener onClickListener) {
        ivLeftBack.setOnClickListener(onClickListener);
    }

    @Override
    public void setRightIVClickListener(OnClickListener onClickListener) {
        ivRightView.setOnClickListener(onClickListener);
    }

    @Override
    public void setRightTVClickListener(OnClickListener onClickListener) {
        tvRight.setOnClickListener(onClickListener);
    }

    @Override
    public void setLeftSecondClickListener(OnClickListener onClickListener) {
        ivLeftSecond.setOnClickListener(onClickListener);
    }

    @Override
    public void setLeftViewVisisable(int visiable) {
        ivLeftBack.setVisibility(visiable);
    }

    @Override
    public void setRightViewVisisable(int visiable) {
        ivRightView.setVisibility(visiable);
    }

    @Override
    public void setTitleViewVisisable(int visiable) {
        tvTitle.setVisibility(visiable);
    }

    @Override
    public void setLineVisiable(int visiable) {
        viewLine.setVisibility(visiable);
    }

    @Override
    public void setBottomLineColor(@ColorInt int colorId) {
        viewLine.setVisibility(VISIBLE);
        viewLine.setBackgroundColor(colorId);
    }

    @Override
    public void setLeftSecondViewResource(@DrawableRes int resid) {
        ivLeftSecond.setBackgroundResource(resid);
    }

    @Override
    public void setLeftSecondViewVisiable(int visiable) {
        ivLeftSecond.setVisibility(VISIBLE);
    }

    @Override
    public void setLeftRedPointVisiable(int visiable) {
        redPoint.setVisibility(visiable);
    }

    @Override
    public void setLeftRedPointSize(int size) {
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams) redPoint.getLayoutParams();
        layoutParams.height = DisplayUtil.dip2px(getContext(), size);
        layoutParams.width = DisplayUtil.dip2px(getContext(), size);
        redPoint.setLayoutParams(layoutParams);
    }

    @Override
    public View getRedPointView() {
        return redPoint;
    }

    @Override
    public RelativeLayout.LayoutParams getRedPointParams() {
        return (RelativeLayout.LayoutParams) redPoint.getLayoutParams();
    }
}

