package com.xdja.poc.common.view;

import android.content.Context;
import android.support.annotation.StringRes;
import android.support.v7.app.AlertDialog;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

import com.xdja.poc.common.R;

public class WarningDialog {
    private AlertDialog alertDialog = null;

    public void showWarningDialog(Context context, @StringRes int messageId, View.OnClickListener cancelListener, View.OnClickListener confirmListener) {
        showWarningDialog(context, -1, -1, messageId, cancelListener, confirmListener);
    }

    public void showWarningDialog(Context context, @StringRes int leftBtnText, @StringRes int rightBtnText, @StringRes int messageId, View.OnClickListener cancelListener, View.OnClickListener confirmListener) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        alertDialog = builder.create();
        //alertDialog.getWindow().setLayout(alertDialog.getContext().getResources().getDimensionPixelSize(R.dimen.px_1000), WindowManager.LayoutParams.WRAP_CONTENT);
        View inflate = View.inflate(context, R.layout.common_warning_dialog_layout, null);
        TextView mBtnCancel = inflate.findViewById(R.id.btn_dialog_cancel);

        TextView mBtnConfirm = inflate.findViewById(R.id.btn_dialog_confirm);
        if (leftBtnText != -1) {
            mBtnCancel.setText(leftBtnText);
        }
        if (rightBtnText != -1) {
            mBtnConfirm.setText(rightBtnText);
        }
        TextView mTvMessage = inflate.findViewById(R.id.tv_message);
        mTvMessage.setText(context.getString(messageId));
        builder.setCancelable(false);
        alertDialog.setView(inflate);
        alertDialog.setCanceledOnTouchOutside(false);
        mBtnCancel.setOnClickListener(cancelListener);
        mBtnConfirm.setOnClickListener(confirmListener);
        WindowManager.LayoutParams layoutParams = alertDialog.getWindow().getAttributes();
        alertDialog.show();
        layoutParams.width = alertDialog.getContext().getResources().getDimensionPixelSize(R.dimen.common_conversation_dialog_width);
        layoutParams.height = WindowManager.LayoutParams.WRAP_CONTENT;
        alertDialog.getWindow().setAttributes(layoutParams);
    }


    public void showInputGroupNameDialog(Context context, @StringRes int leftBtnText, @StringRes int rightBtnText, View.OnClickListener cancelListener, IPocGetGroupName callback) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        alertDialog = builder.create();
        //alertDialog.getWindow().setLayout(alertDialog.getContext().getResources().getDimensionPixelSize(R.dimen.px_1000), WindowManager.LayoutParams.WRAP_CONTENT);
        View inflate = View.inflate(context, R.layout.common_warning_dialog_layout, null);
        TextView mBtnCancel = inflate.findViewById(R.id.btn_dialog_cancel);

        TextView mBtnConfirm = inflate.findViewById(R.id.btn_dialog_confirm);
        if (leftBtnText != -1) {
            mBtnCancel.setText(leftBtnText);
        }
        if (rightBtnText != -1) {
            mBtnConfirm.setText(rightBtnText);
        }
        inflate.findViewById(R.id.tv_message).setVisibility(View.GONE);
        EditText mEt = inflate.findViewById(R.id.et_room_name);
        mEt.setVisibility(View.VISIBLE);
        builder.setCancelable(false);
        alertDialog.setView(inflate);
        alertDialog.setCanceledOnTouchOutside(false);
        mBtnCancel.setOnClickListener(cancelListener);
        mBtnConfirm.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                callback.pocGroupNameCallBack(mEt.getText().toString().trim());
            }
        });
        WindowManager.LayoutParams layoutParams = alertDialog.getWindow().getAttributes();
        alertDialog.show();
        layoutParams.width = alertDialog.getContext().getResources().getDimensionPixelSize(R.dimen.common_conversation_dialog_width);
        layoutParams.height = WindowManager.LayoutParams.WRAP_CONTENT;
        alertDialog.getWindow().setAttributes(layoutParams);
    }

    public void dismissDialog() {
        if (alertDialog != null) {
            alertDialog.dismiss();
            alertDialog = null;
        }
    }

    public interface IPocGetGroupName {
        void pocGroupNameCallBack(String name);
    }

}
