package com.xdja.net.adapter;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;

import java.io.IOException;

import static android.R.attr.value;


/**
 * desc: int 值为null转换
 * author:rookie on 2017/6/7 0007 13:48
 */
public class IntNullAdapter extends TypeAdapter<Integer> {

    @Override
    public void write(JsonWriter writer, Integer integer) throws IOException {
        if (integer == null) {
            writer.nullValue();
            return;
        }
        writer.value(value);
    }

    @Override
    public Integer read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return 0;
        }
        return reader.nextInt();
    }
}