package com.xdja.net.interceptor;


import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;

import java.io.IOException;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

/**
 * janus-gateway-android-master
 * 功能
 * 描述
 * created by Wwq : 2018/8/28
 */
public class HttpHeaderInterceptor implements Interceptor {
    @Override
    public Response intercept(Chain chain) throws IOException {
        //  配置请求头
        String token = PreferenceHelper.getString("pref_key_token", "");
        String companyCode = PreferenceHelper.getString("pref_key_company_code", "");
        if (StringUtils.isEmpty(token) || StringUtils.isEmpty(companyCode)) {
            LogUtils.ELog("HttpHeaderInterceptor", "https request token or companyCode is null");
        }
        Request request = chain.request().newBuilder()
                .header("authorization", token)
                .header("companyCode", companyCode)
                .build();
        long t1 = System.nanoTime();
        LogUtils.DLog("HttpHeaderInterceptor", String.format("Sending request %s on %s%n%s",
                request.url(), chain.connection(), request.headers()));
        Response response = chain.proceed(request);
        long t2 = System.nanoTime();
        LogUtils.DLog("HttpHeaderInterceptor", String.format("Received response for %s in %.1fms%n%s",
                response.request().url(), (t2 - t1) / 1e6d, response.headers()));
        return response;
    }
}
