package com.xdja.net.interceptor;

import com.xdja.poc.common.utils.LogUtils;

import java.io.IOException;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

/**
 * janus-gateway-android-master
 * 功能
 * 描述
 * created by Wwq : 2018/8/28
 */
public class LoggingInterceptor implements Interceptor {
    @Override
    public Response intercept(Chain chain) throws IOException {
        //这个chain里面包含了request和response,所以你要什么都可以从这里拿
        Request request = chain.request();
        long t1 = System.nanoTime();//请求发起的时间
        LogUtils.DLog("LoggingInterceptor", String.format("请求URL------%s on %s%n请求头------%s",
                request.url(), chain.connection(), request.headers()));
        LogUtils.DLog("LoggingInterceptor","请求Body:"+request.body());

        Response response = chain.proceed(request);
        long t2 = System.nanoTime();//收到响应的时间
        //这里不能直接使用response.body().string()的方式输出日志
        //因为response.body().string()之后,response中的流会被关闭,程序会报错,我们需要创建出一
        //个新的response给应用层处理
        ResponseBody responseBody = response.peekBody(1024 * 1024);

        LogUtils.DLog("LoggingInterceptor", String.format("\n响应URL-------: %s %n响应数据------%s %n请求用时--------%.1fms%n%s",
                response.request().url(),
                responseBody.string(),
                (t2 - t1) / 1e6d,
                response.headers()));

        return response;
    }

}
