/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.net;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.xdja.net.interceptor.HttpHeaderInterceptor;
import com.xdja.net.interceptor.LoggingInterceptor;
import com.xdja.net.observer.Transformer;
import com.xdja.net.ssl.HttpsUtils;
import com.xdja.net.throwable.NullObjectConverAdapterFactory;
import com.xdja.net.throwable.RetryFunction;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.functions.Function;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public class RetrofitUtil {
    private static String TAG = "RetrofitUtils";
    private static HttpsUtils.SSLParams sslParams = HttpsUtils.getSslSocketFactory();
    private static Gson gson;
    private static Retrofit retrofit;
    private static Retrofit customHeaderRetrofit;

    public static OkHttpClient getOkHttpClientBuilder(String baseUrl) {
        return RetrofitUtil.getOkHttpClientBuilder(baseUrl, false);
    }

    public static OkHttpClient getOkHttpClientBuilder(String baseUrl, boolean customHeader) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(15L, TimeUnit.SECONDS).readTimeout(15L, TimeUnit.SECONDS).writeTimeout(15L, TimeUnit.SECONDS).connectionPool(new ConnectionPool(5, 5L, TimeUnit.SECONDS)).addInterceptor((Interceptor)new LoggingInterceptor());
        if (!customHeader) {
            builder.addInterceptor((Interceptor)new HttpHeaderInterceptor());
        }
        if (baseUrl.startsWith("https")) {
            builder.sslSocketFactory(RetrofitUtil.sslParams.sSLSocketFactory, RetrofitUtil.sslParams.trustManager).hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
        }
        return builder.build();
    }

    public static Retrofit.Builder getRetrofitBuilder(String baseUrl) {
        OkHttpClient okHttpClient = RetrofitUtil.getOkHttpClientBuilder(baseUrl);
        return new Retrofit.Builder().client(okHttpClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)RetrofitUtil.buildGson())).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).baseUrl(baseUrl);
    }

    public static Retrofit.Builder getCustomHeaderRetrofitBuilder(String baseUrl) {
        OkHttpClient okHttpClient = RetrofitUtil.getOkHttpClientBuilder(baseUrl, true);
        return new Retrofit.Builder().client(okHttpClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)RetrofitUtil.buildGson())).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).baseUrl(baseUrl);
    }

    private static Gson buildGson() {
        if (gson == null) {
            gson = new GsonBuilder().registerTypeAdapterFactory(new NullObjectConverAdapterFactory()).create();
        }
        return gson;
    }

    public static <T> T getApiService(Class<T> cls, String baseUrl) {
        if (baseUrl == null) {
            throw new IllegalArgumentException("baseUrl cant null");
        }
        if (retrofit == null) {
            retrofit = RetrofitUtil.getRetrofitBuilder(baseUrl).build();
        }
        try {
            String host;
            URI uri = new URI(baseUrl);
            String string = host = uri.getHost() == null ? baseUrl : uri.getHost();
            if (!retrofit.baseUrl().url().getHost().equals(host)) {
                retrofit = RetrofitUtil.getRetrofitBuilder(baseUrl).build();
            }
        }
        catch (URISyntaxException e) {
            retrofit = RetrofitUtil.getRetrofitBuilder(baseUrl).build();
        }
        return (T)retrofit.create(cls);
    }

    public static <T> T getCustomHeaderApiService(Class<T> cls, String baseUrl) {
        if (baseUrl == null) {
            throw new IllegalArgumentException("baseUrl cant null");
        }
        if (customHeaderRetrofit == null) {
            customHeaderRetrofit = RetrofitUtil.getCustomHeaderRetrofitBuilder(baseUrl).build();
        }
        try {
            String host;
            URI uri = new URI(baseUrl);
            String string = host = uri.getHost() == null ? baseUrl : uri.getHost();
            if (!customHeaderRetrofit.baseUrl().url().getHost().equals(host)) {
                customHeaderRetrofit = RetrofitUtil.getCustomHeaderRetrofitBuilder(baseUrl).build();
            }
        }
        catch (URISyntaxException e) {
            customHeaderRetrofit = RetrofitUtil.getCustomHeaderRetrofitBuilder(baseUrl).build();
        }
        return (T)customHeaderRetrofit.create(cls);
    }

    public static void request(Observable observable, Observer observer) {
        SingletonHolder.sInstance.requesServer(observable, observer);
    }

    private void requesServer(Observable observable, Observer observer) {
        observable.compose(Transformer.switchSchedulers()).retryWhen((Function)new RetryFunction(0, 0)).subscribe(observer);
    }

    private static class SingletonHolder {
        static final RetrofitUtil sInstance = new RetrofitUtil();

        private SingletonHolder() {
        }
    }
}

