/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.net.interceptor;

import com.xdja.poc.common.utils.LogUtils;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class LoggingInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        long t1 = System.nanoTime();
        LogUtils.DLog((String)"LoggingInterceptor", (String)String.format("\u8bf7\u6c42URL------%s on %s%n\u8bf7\u6c42\u5934------%s", request.url(), chain.connection(), request.headers()));
        LogUtils.DLog((String)"LoggingInterceptor", (String)("\u8bf7\u6c42Body:" + request.body()));
        Response response = chain.proceed(request);
        long t2 = System.nanoTime();
        ResponseBody responseBody = response.peekBody(0x100000L);
        LogUtils.DLog((String)"LoggingInterceptor", (String)String.format("\n\u54cd\u5e94URL-------: %s %n\u54cd\u5e94\u6570\u636e------%s %n\u8bf7\u6c42\u7528\u65f6--------%.1fms%n%s", response.request().url(), responseBody.string(), (double)(t2 - t1) / 1000000.0, response.headers()));
        return response;
    }
}

