/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.net.throwable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.functions.Function;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;

public class RetryFunction
implements Function<Observable<Throwable>, ObservableSource<?>> {
    private int retryDelaySeconds;
    private int retryCountMax;
    private int retryCount;

    public RetryFunction(int retryDelaySeconds, int retryCountMax) {
        this.retryDelaySeconds = retryDelaySeconds;
        this.retryCountMax = retryCountMax;
    }

    public ObservableSource<?> apply(Observable<Throwable> throwableObservable) throws Exception {
        return throwableObservable.flatMap(new Function<Throwable, ObservableSource<?>>(){

            public ObservableSource<?> apply(Throwable throwable) throws Exception {
                if (throwable instanceof UnknownHostException) {
                    return Observable.error((Throwable)throwable);
                }
                if (++RetryFunction.this.retryCount <= RetryFunction.this.retryCountMax) {
                    return Observable.timer((long)RetryFunction.this.retryDelaySeconds, (TimeUnit)TimeUnit.SECONDS);
                }
                return Observable.error((Throwable)throwable);
            }
        });
    }
}

