package com.xdja.net;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.xdja.net.interceptor.HttpHeaderInterceptor;
import com.xdja.net.interceptor.LoggingInterceptor;
import com.xdja.net.observer.Transformer;
import com.xdja.net.ssl.HttpsUtils;
import com.xdja.net.throwable.NullObjectConverAdapterFactory;
import com.xdja.net.throwable.RetryFunction;
import com.xdja.poc.common.bean.BaseResponse;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;

import io.reactivex.Observable;
import io.reactivex.Observer;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

/**
 * janus-gateway-android-master
 * 功能
 * 描述
 * created by Wwq : 2018/8/28
 */

public class RetrofitUtil {
    private static String TAG = "RetrofitUtils";
    private static HttpsUtils.SSLParams sslParams = HttpsUtils.getSslSocketFactory();

    private static class SingletonHolder {
        static final RetrofitUtil sInstance = new RetrofitUtil();
    }

    public static OkHttpClient getOkHttpClientBuilder(String baseUrl){
        return getOkHttpClientBuilder(baseUrl,false);
    }

    public static OkHttpClient getOkHttpClientBuilder(String baseUrl, boolean customHeader) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder()
                .connectTimeout(15, TimeUnit.SECONDS)
                .readTimeout(15, TimeUnit.SECONDS)
                .writeTimeout(15, TimeUnit.SECONDS)
                .connectionPool(new ConnectionPool(5, 5, TimeUnit.SECONDS))
                .addInterceptor(new LoggingInterceptor());
        if (!customHeader) {
            builder.addInterceptor(new HttpHeaderInterceptor());
        }
        if (baseUrl.startsWith("https")) {
            //add https host and certificate verifier
            builder.sslSocketFactory(sslParams.sSLSocketFactory, sslParams.trustManager)
                    .hostnameVerifier(new HostnameVerifier() {
                        @Override
                        public boolean verify(String hostname, SSLSession session) {
                            // TODO: 2018/5/18 check hostname
                            return true;
                        }
                    });
        }
        return builder.build();
    }

    public static Retrofit.Builder getRetrofitBuilder(String baseUrl) {
//        Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").serializeNulls().create();
        OkHttpClient okHttpClient = RetrofitUtil.getOkHttpClientBuilder(baseUrl);
        return new Retrofit.Builder()
                .client(okHttpClient)
                .addConverterFactory(GsonConverterFactory.create(buildGson()))
                .addCallAdapterFactory(RxJava2CallAdapterFactory.create())
                .baseUrl(baseUrl);
    }

    public static Retrofit.Builder getCustomHeaderRetrofitBuilder(String baseUrl) {
//        Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").serializeNulls().create();
        OkHttpClient okHttpClient = RetrofitUtil.getOkHttpClientBuilder(baseUrl,true);
        return new Retrofit.Builder()
                .client(okHttpClient)
                .addConverterFactory(GsonConverterFactory.create(buildGson()))
                .addCallAdapterFactory(RxJava2CallAdapterFactory.create())
                .baseUrl(baseUrl);
    }

    /**
     * 处理值为null
     *
     * @return
     */
    private static Gson gson;

    private static Gson buildGson() {
        if (gson == null) {
            gson = new GsonBuilder().registerTypeAdapterFactory(new NullObjectConverAdapterFactory()).create();
        }
        return gson;
    }

    private static Retrofit retrofit,customHeaderRetrofit;

    public static <T> T getApiService(Class<T> cls, String baseUrl) {
        if (baseUrl == null) {
            throw new IllegalArgumentException("baseUrl cant null");
        }
        if (retrofit == null) {
            retrofit = getRetrofitBuilder(baseUrl).build();
        }
        try {
            URI uri = new URI(baseUrl);
            String host = (uri.getHost() == null ? baseUrl : uri.getHost());
            if (!retrofit.baseUrl().url().getHost().equals(host)) {
                retrofit = getRetrofitBuilder(baseUrl).build();
            }
        } catch (URISyntaxException e) {
            retrofit = getRetrofitBuilder(baseUrl).build();
        }
        return retrofit.create(cls);
    }

    public static <T> T getCustomHeaderApiService(Class<T> cls, String baseUrl) {
        if (baseUrl == null) {
            throw new IllegalArgumentException("baseUrl cant null");
        }
        if (customHeaderRetrofit == null) {
            customHeaderRetrofit = getCustomHeaderRetrofitBuilder(baseUrl).build();
        }
        try {
            URI uri = new URI(baseUrl);
            String host = (uri.getHost() == null ? baseUrl : uri.getHost());
            if (!customHeaderRetrofit.baseUrl().url().getHost().equals(host)) {
                customHeaderRetrofit = getCustomHeaderRetrofitBuilder(baseUrl).build();
            }
        } catch (URISyntaxException e) {
            customHeaderRetrofit = getCustomHeaderRetrofitBuilder(baseUrl).build();
        }
        return customHeaderRetrofit.create(cls);
    }

    public static void request(Observable observable, Observer observer) {
        SingletonHolder.sInstance.requesServer(observable, observer);
    }

    private void requesServer(Observable observable, Observer observer) {
        observable
                .compose(Transformer.<BaseResponse>switchSchedulers())
                .retryWhen(new RetryFunction(0, 0))//本身请求算一次
                .subscribe(observer);
    }
}
