package com.xdja.net.throwable;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.xdja.net.adapter.IntNullAdapter;
import com.xdja.net.adapter.StringNullAdapter;

/**
 * desc: null值转换
 * author:rookie on 2017/6/7 0007 13:48
 */
public class NullObjectConverAdapterFactory<T> implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class<T> rawType = (Class<T>) type.getRawType();
        if (rawType == String.class) {
            return (TypeAdapter<T>) new StringNullAdapter();
        } else if (rawType == Number.class) {
            if (rawType == int.class) {
                return (TypeAdapter<T>) new IntNullAdapter();
            }
        }
        return null;
    }
}
