/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.net.interceptor;

import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class HttpHeaderInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        String token = PreferenceHelper.getString((String)"pref_key_token", (String)"");
        String companyCode = PreferenceHelper.getString((String)"pref_key_company_code", (String)"");
        if (StringUtils.isEmpty((String)token) || StringUtils.isEmpty((String)companyCode)) {
            LogUtils.ELog((String)"HttpHeaderInterceptor", (String)"https request token or companyCode is null");
        }
        Request request = chain.request().newBuilder().header("authorization", token).header("companyCode", companyCode).build();
        long t1 = System.nanoTime();
        LogUtils.DLog((String)"HttpHeaderInterceptor", (String)String.format("Sending request %s on %s%n%s", request.url(), chain.connection(), request.headers()));
        Response response = chain.proceed(request);
        long t2 = System.nanoTime();
        LogUtils.DLog((String)"HttpHeaderInterceptor", (String)String.format("Received response for %s in %.1fms%n%s", response.request().url(), (double)(t2 - t1) / 1000000.0, response.headers()));
        return response;
    }
}

