/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.net.throwable;

import android.net.ParseException;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.xdja.net.throwable.HttpThrowable;
import com.xdja.poc.common.utils.LogUtils;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLHandshakeException;
import org.json.JSONException;
import retrofit2.HttpException;

public class ThrowableHandler {
    public static HttpThrowable handleThrowable(Throwable throwable) {
        if (throwable instanceof HttpException) {
            return new HttpThrowable(1005, "\u7f51\u7edc(\u534f\u8bae)\u5f02\u5e38", throwable);
        }
        if (throwable instanceof JsonParseException || throwable instanceof JSONException || throwable instanceof ParseException) {
            return new HttpThrowable(1001, "\u6570\u636e\u89e3\u6790\u5f02\u5e38", throwable);
        }
        if (throwable instanceof UnknownHostException) {
            return new HttpThrowable(1003, "\u7f51\u7edc\u5f02\u5e38,\u8bf7\u68c0\u67e5\u7f51\u7edc\u8bbe\u7f6e", throwable);
        }
        if (throwable instanceof SocketTimeoutException) {
            return new HttpThrowable(1004, "\u8fde\u63a5\u8d85\u65f6", throwable);
        }
        if (throwable instanceof ConnectException) {
            return new HttpThrowable(1002, "\u8fde\u63a5\u5f02\u5e38", throwable);
        }
        if (throwable instanceof SSLHandshakeException) {
            return new HttpThrowable(1006, "\u8bc1\u4e66\u9a8c\u8bc1\u5931\u8d25", throwable);
        }
        LogUtils.ELog((String)"ThrowableHandler", (String)("httpThrowable: " + throwable.getMessage() + "    " + 1000));
        return new HttpThrowable(1000, throwable.getMessage(), throwable);
    }

    public static <T> T fromJson(Throwable throwable, Class<T> clazz) {
        HttpException httpException = (HttpException)throwable;
        Gson gson = new Gson();
        Object t = null;
        try {
            t = gson.fromJson(httpException.response().errorBody().string(), clazz);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (T)t;
    }
}

