package com.xdja.net.observer;

import com.xdja.net.throwable.HttpThrowable;
import com.xdja.net.throwable.ThrowableHandler;
import com.xdja.poc.common.utils.LogUtils;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;

/**
 * janus-gateway-android-master
 * 功能
 * 描述
 * created by Wwq : 2018/8/28
 */
@SuppressWarnings("ALL")
public abstract class CommonObserver<T> implements Observer<T> {
    @Override
    public void onComplete() {

    }

    @Override
    public void onSubscribe(Disposable d) {
    }

    @Override
    public void onError(Throwable throwable) {
        if (throwable instanceof Exception) {
            onError(ThrowableHandler.handleThrowable(throwable));
        } else {
            onError(new HttpThrowable(HttpThrowable.UNKNOWN, "未知错误", throwable));
        }
    }

    @Override
    public void onNext(T t) {
        if (t != null) {
            LogUtils.DLog("CommonObserver", t.toString());
        }
        onResult(t);
    }

    public abstract void onResult(T result);

    public abstract void onError(HttpThrowable httpThrowable);
}
