/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business.webrtc.janusclientapi;

import com.xdja.poc.sdk.business.webrtc.janusclientapi.IJanusPluginCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IPluginHandleSendMessageCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IPluginHandleWebRTCCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.ITransactionCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusAttachPluginTransaction;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusCreateSessionTransaction;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusSendPluginMessageTransaction;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusServer;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusSupportedPluginPackages;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusWebRtcTransaction;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.TransactionType;

class JanusTransactionCallbackFactory {
    JanusTransactionCallbackFactory() {
    }

    public static ITransactionCallbacks createNewTransactionCallback(JanusServer server, TransactionType type) {
        switch (type) {
            case create: {
                return new JanusCreateSessionTransaction(server);
            }
        }
        return null;
    }

    public static ITransactionCallbacks createNewTransactionCallback(JanusServer server, TransactionType type, JanusSupportedPluginPackages plugin, IPluginHandleWebRTCCallbacks callbacks) {
        switch (type) {
            case plugin_handle_webrtc_message: {
                return new JanusWebRtcTransaction(plugin, callbacks);
            }
        }
        return null;
    }

    public static ITransactionCallbacks createNewTransactionCallback(JanusServer server, TransactionType type, JanusSupportedPluginPackages plugin, IPluginHandleSendMessageCallbacks callbacks) {
        switch (type) {
            case plugin_handle_message: {
                return new JanusSendPluginMessageTransaction(plugin, callbacks);
            }
        }
        return null;
    }

    public static ITransactionCallbacks createNewTransactionCallback(JanusServer server, TransactionType type, JanusSupportedPluginPackages plugin, IJanusPluginCallbacks callbacks) {
        switch (type) {
            case create: {
                return new JanusCreateSessionTransaction(server);
            }
            case attach: {
                return new JanusAttachPluginTransaction(server, plugin, callbacks);
            }
        }
        return null;
    }
}

