/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.db.manager;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.sdk.POCClient;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.db.DBConstant;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import com.xdja.poc.sdk.db.manager.POCSQLiteOpenHelper;
import com.xdja.poc.sdk.utils.GroupUtils;
import java.util.ArrayList;
import java.util.List;

public class PocDaoGroupManager {
    private static PocDaoGroupManager mInstance;
    private POCSQLiteOpenHelper mHelper;
    private SQLiteDatabase db;
    private String TAG = "PocDaoGroupManager";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PocDaoGroupManager getInstance(Context context) {
        if (mInstance != null) return mInstance;
        Class<PocDaoGroupManager> clazz = PocDaoGroupManager.class;
        synchronized (PocDaoGroupManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new PocDaoGroupManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private PocDaoGroupManager(Context context) {
        if (mInstance == null) {
            this.mHelper = new POCSQLiteOpenHelper(context);
            this.db = this.mHelper.getWritableDatabase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void insertOrReplaceGroup(List<DBGroupEntity> groups) {
        try (Cursor cursor = null;){
            for (DBGroupEntity group : groups) {
                cursor = this.db.rawQuery("SELECT * FROM " + DBConstant.CHANNEL_TABLE + " WHERE key=?", new String[]{group.getKey()});
                if (cursor == null || !cursor.moveToFirst()) {
                    if (!StringUtils.isEmpty((String)group.getRoomName()) && group.getRoomName().equals("undefined")) {
                        List<POCMemberInfo> memberInfoList = POCClient.getInstance().generateStringToList(group.getMemeberIds());
                        String strings = GroupUtils.generateGroupMemberTempRoomName((ArrayList)memberInfoList);
                        group.setRoomName(strings);
                    }
                    group.setRoomName(GroupUtils.convertString(group.getRoomName()));
                    this.db.execSQL("INSERT INTO " + DBConstant.CHANNEL_TABLE + " (" + DBConstant.USERID + "," + DBConstant.KEY + "," + DBConstant.OWNERID + "," + DBConstant.ACTIVEUSERID + "," + DBConstant.ROOMID + "," + DBConstant.ROOMNAME + "," + DBConstant.MEMEBERIDS + "," + DBConstant.ONLINECOUNT + "," + DBConstant.ISSILENCE + "," + DBConstant.SPEAKERUSERID + "," + DBConstant.SPEAKERUSERNAME + "," + DBConstant.STATUS + "," + DBConstant.ISTOPSTICK + "," + DBConstant.TOPSTICKINDEX + "," + DBConstant.TOPSTICKTIME + "," + DBConstant.GROUPTYPE + "," + DBConstant.USERNAMES + "," + DBConstant.ISPTTKEY + "," + DBConstant.CHANNELPWD + "," + DBConstant.MAXINVITEMEMBERSCOUNT + "," + DBConstant.CHANNELPWDMODE + ")VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", new Object[]{group.getUserId(), group.getKey(), group.getOwnerId(), group.getActiveUserId(), group.getRooomId(), group.getRoomName(), group.getMemeberIds(), group.getOnLineCount(), 0, group.getSpeakerUserId(), group.getSpeakerUserName(), group.getStatus(), group.getIsTopStick(), group.getTopStickIndex(), group.getTopStickTime(), group.getGroupType(), group.getUserNames(), group.getIsPttKey(), group.getChannelPwd(), group.getMaxInviteMembersCount(), group.getChannelPwdMode()});
                } else {
                    ContentValues values = new ContentValues();
                    values.put(DBConstant.ISSILENCE, Integer.valueOf(cursor.getInt(cursor.getColumnIndex(DBConstant.ISSILENCE))));
                    values.put(DBConstant.TOPSTICKTIME, cursor.getString(cursor.getColumnIndex(DBConstant.TOPSTICKTIME)));
                    values.put(DBConstant.ISTOPSTICK, Integer.valueOf(cursor.getInt(cursor.getColumnIndex(DBConstant.ISTOPSTICK))));
                    String channelName = GroupUtils.convertString(group.getRoomName());
                    values.put(DBConstant.ROOMNAME, channelName);
                    values.put(DBConstant.MEMEBERIDS, group.getMemeberIds());
                    values.put(DBConstant.CHANNELPWDMODE, Boolean.valueOf(group.getChannelPwdMode()));
                    values.put(DBConstant.CHANNELPWD, group.getChannelPwd());
                    values.put(DBConstant.MAXINVITEMEMBERSCOUNT, Integer.valueOf(group.getMaxInviteMembersCount()));
                    values.put(DBConstant.STATUS, Integer.valueOf(cursor.getInt(cursor.getColumnIndex(DBConstant.STATUS))));
                    values.put(DBConstant.ISPTTKEY, Integer.valueOf(cursor.getInt(cursor.getColumnIndex(DBConstant.ISPTTKEY))));
                    this.db.update(DBConstant.CHANNEL_TABLE, values, "key='" + group.getKey() + "'", null);
                }
                LogUtils.ILog((String)this.TAG, (String)" insertOrReplaceGroup success");
            }
        }
    }

    public void deleteGroup(String key) {
        try {
            this.db.execSQL("DELETE FROM " + DBConstant.CHANNEL_TABLE + " WHERE key=?", (Object[])new String[]{key});
            LogUtils.ILog((String)"delete group success");
        }
        catch (Throwable throwable) {
            LogUtils.ELog((Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<DBGroupEntity> getAllPocGroup(String userId) {
        try (Cursor cursor = null;){
            cursor = this.db.rawQuery("SELECT * FROM " + DBConstant.CHANNEL_TABLE + " WHERE userId=?", new String[]{userId});
            if (cursor != null && cursor.getCount() > 0 && cursor.moveToFirst()) {
                ArrayList<DBGroupEntity> adInfos = new ArrayList<DBGroupEntity>();
                for (int m = 0; m < cursor.getCount(); ++m) {
                    DBGroupEntity entity = new DBGroupEntity();
                    entity.setKey(cursor.getString(cursor.getColumnIndex(DBConstant.KEY)));
                    entity.setUserId(cursor.getString(cursor.getColumnIndex(DBConstant.USERID)));
                    entity.setOwnerId(cursor.getString(cursor.getColumnIndex(DBConstant.OWNERID)));
                    entity.setActiveUserId(cursor.getString(cursor.getColumnIndex(DBConstant.ACTIVEUSERID)));
                    entity.setRooomId(cursor.getString(cursor.getColumnIndex(DBConstant.ROOMID)));
                    String channelName = cursor.getString(cursor.getColumnIndex(DBConstant.ROOMNAME));
                    String membersId = cursor.getString(cursor.getColumnIndex(DBConstant.MEMEBERIDS));
                    if (!StringUtils.isEmpty((String)channelName) && channelName.equals("undefined") || StringUtils.isEmpty((String)channelName)) {
                        List<POCMemberInfo> memberInfoList = POCClient.getInstance().generateStringToList(membersId);
                        channelName = GroupUtils.generateGroupMemberTempRoomName((ArrayList)memberInfoList);
                    }
                    entity.setRoomName(channelName);
                    entity.setMemeberIds(membersId);
                    int maxMemberCount = cursor.getInt(cursor.getColumnIndex(DBConstant.MAXINVITEMEMBERSCOUNT));
                    entity.setMaxInviteMembersCount(maxMemberCount);
                    entity.setOnLineCount(cursor.getInt(cursor.getColumnIndex(DBConstant.ONLINECOUNT)));
                    entity.setIsSilence(cursor.getInt(cursor.getColumnIndex(DBConstant.ISSILENCE)));
                    entity.setSpeakerUserId(cursor.getString(cursor.getColumnIndex(DBConstant.SPEAKERUSERID)));
                    entity.setSpeakerUserName(cursor.getString(cursor.getColumnIndex(DBConstant.SPEAKERUSERNAME)));
                    entity.setStatus(cursor.getInt(cursor.getColumnIndex(DBConstant.STATUS)));
                    entity.setIsTopStick(cursor.getInt(cursor.getColumnIndex(DBConstant.ISTOPSTICK)));
                    entity.setTopStickIndex(cursor.getInt(cursor.getColumnIndex(DBConstant.TOPSTICKINDEX)));
                    entity.setTopStickTime(Long.valueOf(cursor.getString(cursor.getColumnIndex(DBConstant.TOPSTICKTIME))));
                    entity.setGroupType(cursor.getInt(cursor.getColumnIndex(DBConstant.GROUPTYPE)));
                    entity.setUserNames(cursor.getString(cursor.getColumnIndex(DBConstant.USERNAMES)));
                    entity.setIsPttKey(cursor.getInt(cursor.getColumnIndex(DBConstant.ISPTTKEY)));
                    entity.setChannelPwd(cursor.getString(cursor.getColumnIndex(DBConstant.CHANNELPWD)));
                    entity.setChannelPwdMode(cursor.getInt(cursor.getColumnIndex(DBConstant.CHANNELPWDMODE)));
                    adInfos.add(entity);
                    cursor.moveToNext();
                }
                ArrayList<DBGroupEntity> m = adInfos;
                return m;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DBGroupEntity getChannelInfoByChannelId(String channelId) {
        String userId = PreferenceHelper.getString((String)"login_account", (String)"");
        try (Cursor cursor = null;){
            String key = GroupUtils.generatePOCGroupDbKey(userId, channelId);
            cursor = this.db.rawQuery("SELECT * FROM " + DBConstant.CHANNEL_TABLE + " WHERE key=?", new String[]{key});
            if (cursor != null && cursor.getCount() > 0 && cursor.moveToFirst()) {
                DBGroupEntity entity = new DBGroupEntity();
                entity.setKey(cursor.getString(cursor.getColumnIndex(DBConstant.KEY)));
                entity.setUserId(cursor.getString(cursor.getColumnIndex(DBConstant.USERID)));
                entity.setOwnerId(cursor.getString(cursor.getColumnIndex(DBConstant.OWNERID)));
                entity.setActiveUserId(cursor.getString(cursor.getColumnIndex(DBConstant.ACTIVEUSERID)));
                entity.setRooomId(cursor.getString(cursor.getColumnIndex(DBConstant.ROOMID)));
                String channelName = cursor.getString(cursor.getColumnIndex(DBConstant.ROOMNAME));
                String membersId = cursor.getString(cursor.getColumnIndex(DBConstant.MEMEBERIDS));
                if (!StringUtils.isEmpty((String)channelName) && channelName.equals("undefined") || StringUtils.isEmpty((String)channelName)) {
                    List<POCMemberInfo> memberInfoList = POCClient.getInstance().generateStringToList(membersId);
                    channelName = GroupUtils.generateGroupMemberTempRoomName((ArrayList)memberInfoList);
                }
                int maxMemberCount = cursor.getInt(cursor.getColumnIndex(DBConstant.MAXINVITEMEMBERSCOUNT));
                entity.setMaxInviteMembersCount(maxMemberCount);
                entity.setRoomName(channelName);
                entity.setMemeberIds(membersId);
                entity.setOnLineCount(cursor.getInt(cursor.getColumnIndex(DBConstant.ONLINECOUNT)));
                entity.setIsSilence(cursor.getInt(cursor.getColumnIndex(DBConstant.ISSILENCE)));
                entity.setSpeakerUserId(cursor.getString(cursor.getColumnIndex(DBConstant.SPEAKERUSERID)));
                entity.setSpeakerUserName(cursor.getString(cursor.getColumnIndex(DBConstant.SPEAKERUSERNAME)));
                entity.setStatus(cursor.getInt(cursor.getColumnIndex(DBConstant.STATUS)));
                entity.setIsTopStick(cursor.getInt(cursor.getColumnIndex(DBConstant.ISTOPSTICK)));
                entity.setTopStickIndex(cursor.getInt(cursor.getColumnIndex(DBConstant.TOPSTICKINDEX)));
                entity.setTopStickTime(Long.valueOf(cursor.getString(cursor.getColumnIndex(DBConstant.TOPSTICKTIME))));
                entity.setGroupType(cursor.getInt(cursor.getColumnIndex(DBConstant.GROUPTYPE)));
                entity.setUserNames(cursor.getString(cursor.getColumnIndex(DBConstant.USERNAMES)));
                entity.setIsPttKey(cursor.getInt(cursor.getColumnIndex(DBConstant.ISPTTKEY)));
                entity.setChannelPwd(cursor.getString(cursor.getColumnIndex(DBConstant.CHANNELPWD)));
                entity.setChannelPwdMode(cursor.getInt(cursor.getColumnIndex(DBConstant.CHANNELPWDMODE)));
                DBGroupEntity dBGroupEntity = entity;
                return dBGroupEntity;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGroupIsSilence(String userId, String roomId, boolean isSilence) {
        try (Cursor cursor = null;){
            String key = GroupUtils.generatePOCGroupDbKey(userId, roomId);
            cursor = this.db.rawQuery("SELECT * FROM " + DBConstant.CHANNEL_TABLE + " WHERE key=?", new String[]{key});
            if (cursor != null && cursor.moveToFirst()) {
                ContentValues values = new ContentValues();
                values.put(DBConstant.ISSILENCE, Integer.valueOf(isSilence ? 1 : 0));
                this.db.update(DBConstant.CHANNEL_TABLE, values, "key='" + key + "'", null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateGroupIsPttKey(List<DBGroupEntity> entitieList, String userId, String channelId, boolean isPtt) {
        try (Cursor cursor = null;){
            for (DBGroupEntity entity : entitieList) {
                if (!entity.getIsPttKey()) continue;
                String key = GroupUtils.generatePOCGroupDbKey(entity.getUserId(), entity.getRooomId());
                cursor = this.db.rawQuery("SELECT * FROM " + DBConstant.CHANNEL_TABLE + " WHERE key=?", new String[]{key});
                if (cursor == null || !cursor.moveToFirst()) continue;
                ContentValues values = new ContentValues();
                values.put(DBConstant.ISPTTKEY, Integer.valueOf(0));
                this.db.update(DBConstant.CHANNEL_TABLE, values, "key='" + key + "'", null);
            }
            String key = GroupUtils.generatePOCGroupDbKey(userId, channelId);
            cursor = this.db.rawQuery("SELECT * FROM " + DBConstant.CHANNEL_TABLE + " WHERE key=?", new String[]{key});
            if (cursor != null && cursor.moveToFirst()) {
                ContentValues values = new ContentValues();
                values.put(DBConstant.ISPTTKEY, Integer.valueOf(isPtt ? 1 : 0));
                this.db.update(DBConstant.CHANNEL_TABLE, values, "key='" + key + "'", null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGroupIsTopStick(String userId, String roomId, boolean isStick) {
        try (Cursor cursor = null;){
            String key = GroupUtils.generatePOCGroupDbKey(userId, roomId);
            cursor = this.db.rawQuery("SELECT * FROM " + DBConstant.CHANNEL_TABLE + " WHERE key=?", new String[]{key});
            if (cursor != null && cursor.moveToFirst()) {
                ContentValues values = new ContentValues();
                values.put(DBConstant.ISTOPSTICK, Integer.valueOf(isStick ? 1 : 0));
                values.put(DBConstant.TOPSTICKTIME, String.valueOf(System.currentTimeMillis()));
                this.db.update(DBConstant.CHANNEL_TABLE, values, "key='" + key + "'", null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String insertOrReplaceTempGroup(DBGroupEntity group) {
        try (Cursor cursor = null;){
            Object values;
            cursor = this.db.rawQuery("SELECT * FROM " + DBConstant.CHANNEL_TABLE + " WHERE key=?", new String[]{group.getKey()});
            if (cursor != null && !cursor.moveToFirst()) {
                this.db.execSQL("INSERT INTO " + DBConstant.CHANNEL_TABLE + " (" + DBConstant.USERID + "," + DBConstant.KEY + "," + DBConstant.OWNERID + "," + DBConstant.ACTIVEUSERID + "," + DBConstant.ROOMID + "," + DBConstant.ROOMNAME + "," + DBConstant.MEMEBERIDS + "," + DBConstant.ONLINECOUNT + "," + DBConstant.ISSILENCE + "," + DBConstant.SPEAKERUSERID + "," + DBConstant.SPEAKERUSERNAME + "," + DBConstant.STATUS + "," + DBConstant.ISTOPSTICK + "," + DBConstant.TOPSTICKINDEX + "," + DBConstant.TOPSTICKTIME + "," + DBConstant.GROUPTYPE + "," + DBConstant.USERNAMES + "," + DBConstant.ISPTTKEY + "," + DBConstant.CHANNELPWD + "," + DBConstant.MAXINVITEMEMBERSCOUNT + "," + DBConstant.CHANNELPWDMODE + ")VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", new Object[]{group.getUserId(), group.getKey(), group.getOwnerId(), group.getActiveUserId(), group.getRooomId(), group.getRoomName(), group.getMemeberIds(), group.getOnLineCount(), group.getIsSilence(), group.getSpeakerUserId(), group.getSpeakerUserName(), group.getStatus(), group.getIsTopStick(), group.getTopStickIndex(), group.getTopStickTime(), group.getGroupType(), group.getUserNames(), group.getIsPttKey(), group.getChannelPwd(), group.getMaxInviteMembersCount(), group.getChannelPwdMode()});
            } else {
                values = new ContentValues();
                values.put(DBConstant.ISTOPSTICK, Integer.valueOf(0));
                values.put(DBConstant.TOPSTICKTIME, String.valueOf(System.currentTimeMillis()));
                this.db.update(DBConstant.CHANNEL_TABLE, values, "key='" + group.getKey() + "'", null);
            }
            LogUtils.ILog((String)this.TAG, (String)" insertOrReplaceGroup success");
            values = group.getMemeberIds();
            return values;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGroupNanme(String userId, String roomId, String groupName) {
        try (Cursor cursor = null;){
            String key = GroupUtils.generatePOCGroupDbKey(userId, roomId);
            cursor = this.db.rawQuery("SELECT * FROM " + DBConstant.CHANNEL_TABLE + " WHERE key=?", new String[]{key});
            if (cursor != null && cursor.moveToFirst()) {
                ContentValues values = new ContentValues();
                values.put(DBConstant.ROOMNAME, groupName);
                this.db.update(DBConstant.CHANNEL_TABLE, values, "key='" + key + "'", null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGroupPwd(String userId, String roomId, String pwd) {
        try (Cursor cursor = null;){
            String key = GroupUtils.generatePOCGroupDbKey(userId, roomId);
            cursor = this.db.rawQuery("SELECT * FROM " + DBConstant.CHANNEL_TABLE + " WHERE key=?", new String[]{key});
            if (cursor != null && cursor.moveToFirst()) {
                ContentValues values = new ContentValues();
                values.put(DBConstant.CHANNELPWD, pwd);
                this.db.update(DBConstant.CHANNEL_TABLE, values, "key='" + key + "'", null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGroupPwdMode(String userId, String roomId, boolean channelPwdMode) {
        try (Cursor cursor = null;){
            String key = GroupUtils.generatePOCGroupDbKey(userId, roomId);
            cursor = this.db.rawQuery("SELECT * FROM " + DBConstant.CHANNEL_TABLE + " WHERE key=?", new String[]{key});
            if (cursor != null && cursor.moveToFirst()) {
                ContentValues values = new ContentValues();
                values.put(DBConstant.CHANNELPWDMODE, Integer.valueOf(channelPwdMode ? 1 : 0));
                this.db.update(DBConstant.CHANNEL_TABLE, values, "key='" + key + "'", null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBGroupEntity getPttChannel(String userId) {
        try (Cursor cursor = null;){
            cursor = this.db.rawQuery("SELECT * FROM " + DBConstant.CHANNEL_TABLE + " WHERE isPttKey=? and userId=?", new String[]{"1", userId});
            if (cursor != null && cursor.getCount() > 0 && cursor.moveToFirst()) {
                DBGroupEntity dbGroupEntity = new DBGroupEntity();
                String channelId = cursor.getString(cursor.getColumnIndex(DBConstant.ROOMID));
                dbGroupEntity.setRooomId(channelId);
                dbGroupEntity.setStatus(cursor.getInt(cursor.getColumnIndex(DBConstant.STATUS)));
                DBGroupEntity dBGroupEntity = dbGroupEntity;
                return dBGroupEntity;
            }
        }
        return null;
    }

    public void clearChannelInfo(String mUserId) {
        try {
            this.db.execSQL("DELETE FROM " + DBConstant.CHANNEL_TABLE + " WHERE userId=?", (Object[])new String[]{mUserId});
            LogUtils.ELog((String)this.TAG, (String)"db clearChannelInfo success");
        }
        catch (Exception e) {
            LogUtils.ELog((Throwable)e);
        }
    }

    public void close() {
        try {
            if (this.db != null) {
                this.db.close();
            }
            if (this.mHelper != null) {
                this.mHelper.close();
            }
            mInstance = null;
        }
        catch (Exception e) {
            LogUtils.ELog((Throwable)e);
        }
    }
}

