/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.ui.main.holder;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.support.annotation.IdRes;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.jude.easyrecyclerview.adapter.BaseViewHolder;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.bean.POCMemberInfo;

public class PocMemberInfoListHolder
extends BaseViewHolder<POCMemberInfo> {
    private TextView mTvName;
    private TextView mTvPart;
    private TextView mTvId;
    private ImageView mImgHeadIcon;
    private ImageView mImgIsSelected;
    private View mRelItemRoot;
    private IHolderClickLinstener mListener;
    private final String mUserId;

    public PocMemberInfoListHolder(ViewGroup itemView, IHolderClickLinstener listener) {
        super(itemView, R.layout.poc_conversation_list_item_layout);
        this.mListener = listener;
        this.mUserId = PreferenceHelper.getString((String)"login_account", (String)"");
        this.mRelItemRoot = this.$(R.id.rel_item_root);
        this.mImgHeadIcon = (ImageView)this.$(R.id.img_head_icon);
        this.mTvName = (TextView)this.$(R.id.tv_name);
        this.mTvPart = (TextView)this.$(R.id.tv_part);
        this.mTvId = (TextView)this.$(R.id.tv_small_text);
        this.mImgIsSelected = (ImageView)this.$(R.id.img_is_select);
    }

    @SuppressLint(value={"SetTextI18n"})
    public void setData(POCMemberInfo data) {
        super.setData((Object)data);
        ColorMatrix cm = new ColorMatrix();
        if (data.isOnLine()) {
            this.mImgHeadIcon.setColorFilter(null);
            if (!StringUtils.isEmpty((String)data.getIcon())) {
                Glide.with((Context)this.getContext()).load(data.getIcon()).placeholder(R.drawable.poc_icon_default_avatar).dontAnimate().diskCacheStrategy(DiskCacheStrategy.ALL).into(this.mImgHeadIcon);
            } else {
                this.mImgHeadIcon.setImageResource(R.drawable.poc_icon_default_avatar);
            }
            this.mRelItemRoot.setBackgroundColor(this.getContext().getResources().getColor(R.color.poc_btn_text_press));
        } else {
            if (!StringUtils.isEmpty((String)data.getIcon())) {
                Glide.with((Context)this.getContext()).load(data.getIcon()).placeholder(R.drawable.poc_icon_default_offline_avatar).dontAnimate().diskCacheStrategy(DiskCacheStrategy.ALL).into(this.mImgHeadIcon);
                cm.setSaturation(0.0f);
                ColorMatrixColorFilter grayColorFilter = new ColorMatrixColorFilter(cm);
                this.mImgHeadIcon.setColorFilter((ColorFilter)grayColorFilter);
            } else {
                this.mImgHeadIcon.setImageResource(R.drawable.poc_icon_default_offline_avatar);
            }
            this.mRelItemRoot.setBackgroundColor(this.getContext().getResources().getColor(R.color.poc_conversation_item_selected));
        }
        this.mTvName.setText((CharSequence)data.getName());
        if (!TextUtils.isEmpty((CharSequence)data.getAccount()) && data.getAccount().equals(this.mUserId)) {
            this.mTvName.setText((CharSequence)"\u6211");
        }
        if (!TextUtils.isEmpty((CharSequence)data.getDeptName())) {
            this.mTvPart.setText((CharSequence)data.getDeptName());
            this.mTvPart.setVisibility(0);
        } else {
            this.mTvPart.setVisibility(8);
        }
        if (!TextUtils.isEmpty((CharSequence)data.getAccount())) {
            this.mTvId.setText((CharSequence)("\u5e10\u53f7: " + data.getAccount()));
        }
        this.mImgIsSelected.setVisibility(4);
        this.mImgHeadIcon.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PocMemberInfoListHolder.this.mListener != null) {
                    PocMemberInfoListHolder.this.mListener.OnClick(v.getId(), PocMemberInfoListHolder.this.getAdapterPosition());
                }
            }
        });
        if (data.isChecked()) {
            this.mImgIsSelected.setImageDrawable(this.getContext().getDrawable(R.drawable.poc_member_selected));
        } else {
            this.mImgIsSelected.setImageDrawable(this.getContext().getDrawable(R.drawable.poc_member_noselect));
        }
    }

    public static interface IHolderClickLinstener {
        public void OnClick(@IdRes int var1, int var2);
    }
}

