/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.utils;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.MediaPlayer;
import android.util.Property;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.ui.conversion.POCWarningToneCompleteCallBack;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class MusicHelper {
    public static final int TYPE_END_GO = 1;
    public static final int TYPE_READY_GO = 2;
    private SparseArray<MusicPlayer> mPlayers = new SparseArray();
    private SparseBooleanArray mDisableMusics = new SparseBooleanArray();
    private static MusicHelper sSelf;

    public static String typeToString(int type) {
        switch (type) {
            case 1: {
                return "end-background";
            }
            case 2: {
                return "ready-go";
            }
        }
        return "unknow-" + type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MusicHelper getInstance(Context context) {
        if (sSelf != null) {
            return sSelf;
        }
        Class<MusicHelper> clazz = MusicHelper.class;
        synchronized (MusicHelper.class) {
            if (sSelf == null) {
                sSelf = new MusicHelper(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sSelf;
        }
    }

    private MusicHelper(Context context) {
        Context mAppContext = context.getApplicationContext();
        this.mPlayers.append(2, (Object)new MusicPlayer(R.raw.poc_ppt_start, MusicHelper.typeToString(2), mAppContext, false));
        this.mPlayers.append(1, (Object)new MusicPlayer(R.raw.poc_ppt_stop, MusicHelper.typeToString(1), mAppContext, false));
    }

    public synchronized MusicPlayer playMusic(int type, boolean fadeIn) {
        MusicPlayer player = (MusicPlayer)this.mPlayers.get(type);
        if (player == null) {
            throw new IllegalArgumentException("Unsupport type:" + MusicHelper.typeToString(type));
        }
        if (this.mDisableMusics.get(type)) {
            return player;
        }
        player.play(fadeIn);
        return player;
    }

    public MusicHelper pauseMusic(int type, boolean fadeOut) {
        MusicPlayer player = (MusicPlayer)this.mPlayers.get(type);
        if (player == null) {
            throw new IllegalArgumentException("Unsupport type:" + MusicHelper.typeToString(type));
        }
        if (this.mDisableMusics.get(type)) {
            return this;
        }
        player.pause(fadeOut);
        return this;
    }

    public void disableMusic(int ... music) {
        if (music == null || music.length == 0) {
            return;
        }
        for (int type : music) {
            this.mDisableMusics.put(type, true);
        }
    }

    public static class VolumeProperty
    extends Property<MusicPlayer, Float> {
        public VolumeProperty() {
            super(Float.class, "volume");
        }

        public Float get(MusicPlayer object) {
            return Float.valueOf(object.getVolume());
        }

        public void set(MusicPlayer object, Float value) {
            object.setVolume(value.floatValue());
        }
    }

    public static class MusicPlayer {
        private static final String TAG = "MusicPlayer";
        private static final int STATE_STOPED = 1;
        private static final int STATE_PREPARING = 2;
        private static final int STATE_PLAYING_FADING = 3;
        private static final int STATE_PLAYING = 4;
        private static final int STATE_PAUSE_FADING = 5;
        private static final int STATE_PAUSED = 6;
        private MediaPlayer mMediaPlayer;
        private final int mMusicId;
        private final String mType;
        private final Context mAppContext;
        private final boolean mLoop;
        private int mState = 1;
        private boolean mFade;
        private float mCurrentVolume;
        private ObjectAnimator mVolumeAnimator;
        private POCWarningToneCompleteCallBack mCompleteListener;
        private MediaPlayer.OnPreparedListener mPreparedListener = new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mp) {
                LogUtils.ELog((String)MusicPlayer.TAG, (String)("mState: " + mState));
                if (mState != 2) {
                    if (mCompleteListener != null) {
                        mCompleteListener.completeCallBack();
                    }
                    return;
                }
                LogUtils.ELog((String)MusicPlayer.TAG, (String)("mLoop: " + mLoop));
                if (mLoop) {
                    mp.setLooping(true);
                }
                LogUtils.ELog((String)MusicPlayer.TAG, (String)("mFade: " + mFade));
                if (mFade) {
                    mp.setVolume(1.0f, 1.0f);
                    this.setState(3);
                    this.fade(true);
                } else {
                    mMediaPlayer.setVolume(0.5f, 0.5f);
                    this.setState(4);
                }
                mp.start();
            }
        };
        private MediaPlayer.OnCompletionListener mCompletionListener = new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mp) {
                if (mState != 1) {
                    if (mLoop) {
                        mp.start();
                    } else {
                        this.setState(1);
                    }
                }
                this.releasePlayer();
                if (mCompleteListener != null) {
                    mCompleteListener.completeCallBack();
                }
            }
        };

        public void setCompleteListener(POCWarningToneCompleteCallBack callBack) {
            this.mCompleteListener = callBack;
        }

        private void clearVolumeAnimator() {
            if (this.mVolumeAnimator != null) {
                this.mVolumeAnimator.cancel();
                this.mVolumeAnimator = null;
            }
        }

        private void fade(boolean in) {
        }

        public void setVolume(float volume) {
            this.mCurrentVolume = volume;
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.setVolume(volume, volume);
            }
        }

        public float getVolume() {
            return this.mCurrentVolume;
        }

        public static String stateToString(int state) {
            switch (state) {
                case 1: {
                    return "stoped";
                }
                case 6: {
                    return "paused";
                }
                case 5: {
                    return "pause-fading";
                }
                case 3: {
                    return "playing-fading";
                }
                case 4: {
                    return "playing";
                }
                case 2: {
                    return "preparing";
                }
            }
            return "unknow-" + state;
        }

        private void setState(int state) {
            if (state == this.mState) {
                return;
            }
            LogUtils.DLog((String)"MusicHelper", (String)String.format("setState for %s, %s -> %s", this.mType, MusicPlayer.stateToString(this.mState), MusicPlayer.stateToString(state)));
            this.mState = state;
        }

        public MusicPlayer(int mMusicId, String mType, Context mAppContext, boolean mLoop) {
            this.mMusicId = mMusicId;
            this.mType = mType;
            this.mAppContext = mAppContext;
            this.mLoop = mLoop;
        }

        public void releasePlayer() {
            try {
                if (this.mMediaPlayer != null) {
                    this.mMediaPlayer.stop();
                    this.mMediaPlayer.release();
                    this.mMediaPlayer.setOnCompletionListener(null);
                    this.mMediaPlayer.setOnPreparedListener(null);
                    this.mMediaPlayer = null;
                }
                this.setState(1);
                this.clearVolumeAnimator();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mCurrentVolume = 0.0f;
        }

        public synchronized void play(boolean fade) {
            this.mFade = fade;
            switch (this.mState) {
                case 2: 
                case 4: {
                    return;
                }
                case 1: {
                    this.releasePlayer();
                    this.mMediaPlayer = new MediaPlayer();
                    AssetFileDescriptor afd = this.mAppContext.getResources().openRawResourceFd(this.mMusicId);
                    try {
                        this.mMediaPlayer.setAudioStreamType(2);
                        this.mMediaPlayer.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength());
                        this.mMediaPlayer.setOnPreparedListener(this.mPreparedListener);
                        this.mMediaPlayer.setOnCompletionListener(this.mCompletionListener);
                        this.mMediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                            public boolean onError(MediaPlayer mediaPlayer, int i, int i1) {
                                this.releasePlayer();
                                if (mCompleteListener != null) {
                                    mCompleteListener.completeCallBack();
                                }
                                return false;
                            }
                        });
                        this.setState(2);
                        this.mMediaPlayer.prepareAsync();
                    }
                    catch (Exception e) {
                        this.releasePlayer();
                        if (this.mCompleteListener != null) {
                            this.mCompleteListener.completeCallBack();
                        }
                        this.setState(1);
                        e.printStackTrace();
                    }
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    try {
                        if (fade) {
                            this.mMediaPlayer.setVolume(0.0f, 0.0f);
                            this.mMediaPlayer.start();
                            this.setState(3);
                            this.fade(true);
                            break;
                        }
                        this.mMediaPlayer.setVolume(0.5f, 0.5f);
                        this.setState(4);
                        this.mMediaPlayer.start();
                        break;
                    }
                    catch (Exception e) {
                        LogUtils.ELog((String)TAG, (String)e.getLocalizedMessage());
                        this.releasePlayer();
                        if (this.mCompleteListener != null) {
                            this.mCompleteListener.completeCallBack();
                        }
                        this.setState(1);
                    }
                }
            }
        }

        public synchronized void pause(boolean fade) {
            this.mFade = fade;
            switch (this.mState) {
                case 3: 
                case 4: {
                    if (fade) {
                        this.setState(5);
                        this.fade(false);
                        break;
                    }
                    this.setState(6);
                    this.mMediaPlayer.pause();
                    break;
                }
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface State {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

