package com.xdja.poc.sdk.utils;

import com.xdja.poc.common.utils.CommonUtils;
import com.xdja.poc.common.utils.GlobalContext;
import com.xdja.poc.common.utils.LogUtils;

import java.util.Properties;

/**
 * janus-gateway-android-master
 * 功能
 * 描述
 * created by Wwq : 2018/8/30
 */
@SuppressWarnings("ALL")
public class IPHost {
    public static final String DEFAULT_CONTENT_TYPE = "application/json";

    /**
     * 读取JANUS_API
     *
     * @return
     */
    public static String getJanusServer() {
        Properties properties = CommonUtils.readProperties(GlobalContext.getContext(), "poc_api.properties");
        if (properties != null) {
            return properties.getProperty("JANUS_URI");
        }
        return "";
    }

    /**
     * 读取JANUS_API
     *
     * @return
     */
    public static String getLoadBalanceServer() {
        Properties properties = CommonUtils.readProperties(GlobalContext.getContext(), "poc_api.properties");
        if (properties != null) {
            return properties.getProperty("JANUS_LOAD_BALANCE_URI");
        }
        return "";
    }

    /**
     * 读取MIS_API
     *
     * @return
     */
    public static String getMisServer() {
        Properties properties = CommonUtils.readProperties(GlobalContext.getContext(), "poc_api.properties");
        if (properties != null) {
            return properties.getProperty("MIS_BASE_URL");
        }
        return "";
    }

    public static String getStunServer() {
        Properties properties = CommonUtils.readProperties(GlobalContext.getContext(), "poc_api.properties");
        if (properties != null) {
            return properties.getProperty("ICE_SERVER");
        }
        LogUtils.ELog("IPHOST", "getStunServer: need add poc_api_properties to assets directory");
        return "";
    }

    public static String getStunUrls() {
        Properties properties = CommonUtils.readProperties(GlobalContext.getContext(), "poc_api.properties");
        if (properties != null) {
            return properties.getProperty("ICE_URLS");
        }
        LogUtils.ELog("IPHOST", "getStunUrls: need add poc_api_properties to assets directory");
        return "";
    }

    public static String getFastDfsUrl() {
        Properties properties = CommonUtils.readProperties(GlobalContext.getContext(), "poc_api.properties");
        if (properties != null) {
            return properties.getProperty("POC_FAST_DFS_URL");
        }
        LogUtils.ELog("IPHOST", "getFastDfsUrl: need add poc_api_properties to assets directory");
        return "";
    }

    public static String getFastDfsSecret() {
        Properties properties = CommonUtils.readProperties(GlobalContext.getContext(), "poc_api.properties");
        if (properties != null) {
            return properties.getProperty("POC_FAST_DFS_APPSECRET");
        }
        LogUtils.ELog("IPHOST", "getFastDfsSecret: need add poc_api_properties to assets directory");
        return "";
    }

    public static String getFastDfsAppId() {
        Properties properties = CommonUtils.readProperties(GlobalContext.getContext(), "poc_api.properties");
        if (properties != null) {
            return properties.getProperty("POC_FAST_DFS_APPID");
        }
        LogUtils.ELog("IPHOST", "getFastDfsAppId: need add poc_api_properties to assets directory");
        return "";
    }
}
