/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.greendao;

import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.sdk.greendao.dao.POCHistoryMessageDao;
import com.xdja.poc.sdk.greendao.manager.GreenDaoManager;
import com.xdja.poc.sdk.ui.history.POCHistoryMessage;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.query.WhereCondition;

public class HistoryMessageDBHelper {
    private static final String TAG = HistoryMessageDBHelper.class.getSimpleName();
    private final GreenDaoManager daoManager = GreenDaoManager.getInstance();
    private static HistoryMessageDBHelper dbHelper;
    private static final long MAX_CACHE_MESSAGE_TIME_INTERVAL = 518400000L;

    private HistoryMessageDBHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HistoryMessageDBHelper getInstance() {
        if (dbHelper != null) return dbHelper;
        Class<HistoryMessageDBHelper> clazz = HistoryMessageDBHelper.class;
        synchronized (HistoryMessageDBHelper.class) {
            if (dbHelper != null) return dbHelper;
            dbHelper = new HistoryMessageDBHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return dbHelper;
        }
    }

    public synchronized void insertOrUpdate(POCHistoryMessage historyMessage) {
        this.delete();
        if (historyMessage == null) {
            return;
        }
        this.getPocHistoryMessageDao().insertOrReplaceInTx(new POCHistoryMessage[]{historyMessage});
        LogUtils.DLog((String)TAG, (String)"insert success");
    }

    public synchronized void insertOrUpdate(List<POCHistoryMessage> historyMessages) {
        this.delete();
        if (historyMessages == null || historyMessages.size() == 0) {
            return;
        }
        long time = this.getTime();
        for (POCHistoryMessage message : historyMessages) {
            message.setLocalCacheTime(String.valueOf(time));
        }
        this.getPocHistoryMessageDao().insertOrReplaceInTx(historyMessages);
        LogUtils.DLog((String)TAG, (String)"insert success");
    }

    public synchronized List<POCHistoryMessage> query(String room, int pageSize, long time) {
        this.delete();
        List result = time == 0L ? this.getPocHistoryMessageDao().queryBuilder().where(POCHistoryMessageDao.Properties.GroupUri.eq((Object)room), new WhereCondition[0]).orderDesc(new Property[]{POCHistoryMessageDao.Properties.SyncTime}).limit(pageSize).build().list() : this.getPocHistoryMessageDao().queryBuilder().where(POCHistoryMessageDao.Properties.SyncTime.lt((Object)time), new WhereCondition[]{POCHistoryMessageDao.Properties.GroupUri.eq((Object)room)}).orderAsc(new Property[]{POCHistoryMessageDao.Properties.SyncTime}).limit(pageSize).build().list();
        Collections.sort(result, new Comparator<POCHistoryMessage>(){

            @Override
            public int compare(POCHistoryMessage o1, POCHistoryMessage o2) {
                return o1.getSyncTime().compareTo(o2.getSyncTime());
            }
        });
        LogUtils.DLog((String)TAG, (String)"query success");
        return result;
    }

    public synchronized List<POCHistoryMessage> getAllData(String room) {
        this.delete();
        List result = this.getPocHistoryMessageDao().queryBuilder().where(POCHistoryMessageDao.Properties.GroupUri.eq((Object)room), new WhereCondition[0]).orderAsc(new Property[]{POCHistoryMessageDao.Properties.SyncTime}).build().list();
        Collections.sort(result, new Comparator<POCHistoryMessage>(){

            @Override
            public int compare(POCHistoryMessage o1, POCHistoryMessage o2) {
                return o1.getSyncTime().compareTo(o2.getSyncTime());
            }
        });
        LogUtils.DLog((String)TAG, (String)"query success");
        return result;
    }

    public synchronized void delete() {
        long time = this.getTime() - 518400000L;
        List result = this.getPocHistoryMessageDao().queryBuilder().where(POCHistoryMessageDao.Properties.LocalCacheTime.le((Object)time), new WhereCondition[0]).build().list();
        if (result != null && result.size() > 0) {
            LogUtils.DLog((String)TAG, (String)"\u7f13\u5b58\u6d88\u606f\u8d85\u8fc7\u6700\u5927\u7f13\u5b58\u671f\u9650\uff0c\u89e6\u53d1\u81ea\u52a8\u5220\u9664\u673a\u5236");
            this.deleteLocalFile(result);
            this.getPocHistoryMessageDao().deleteInTx(result);
        }
        LogUtils.DLog((String)TAG, (String)"delete success");
    }

    public long count(String room) {
        this.delete();
        return this.getPocHistoryMessageDao().queryBuilder().where(POCHistoryMessageDao.Properties.GroupUri.eq((Object)room), new WhereCondition[0]).build().list().size();
    }

    private POCHistoryMessageDao getPocHistoryMessageDao() {
        return this.daoManager.getDaoSession().getPOCHistoryMessageDao();
    }

    private void deleteLocalFile(List<POCHistoryMessage> result) {
        for (POCHistoryMessage message : result) {
            File dir;
            String uri = message.getLocalCacheUri();
            if (StringUtils.isEmpty((String)uri)) continue;
            File file = new File(uri);
            if (file.exists()) {
                file.delete();
            }
            if ((dir = new File(uri.substring(0, uri.lastIndexOf("/") - 1))).list() == null || dir.list().length != 0) continue;
            dir.delete();
        }
    }

    private long getTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd", Locale.CHINA);
        long time = 0L;
        try {
            Date destDate = dateFormat.parse(dateFormat.format(new Date()));
            time = destDate.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return time;
    }
}

