/*
 * Decompiled with CFR 0.152.
 */
package de.tavendo.autobahn;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.NetUtils;
import de.tavendo.autobahn.SocketThread;
import de.tavendo.autobahn.WebSocket;
import de.tavendo.autobahn.WebSocketException;
import de.tavendo.autobahn.WebSocketMessage;
import de.tavendo.autobahn.WebSocketOptions;
import de.tavendo.autobahn.WebSocketReader;
import de.tavendo.autobahn.WebSocketWriter;
import java.lang.ref.WeakReference;
import java.net.Socket;
import java.net.URI;
import java.util.Arrays;

public class WebSocketConnection
implements WebSocket {
    private static final String TAG = WebSocketConnection.class.getName();
    private static final String WS_URI_SCHEME = "ws";
    private static final String WSS_URI_SCHEME = "wss";
    private static final String WS_WRITER = "WebSocketWriter";
    private static final String WS_READER = "WebSocketReader";
    private final Handler mHandler;
    private Context mContext;
    private WebSocketReader mWebSocketReader;
    private WebSocketWriter mWebSocketWriter;
    private Socket mSocket;
    private SocketThread mSocketThread;
    private URI mWebSocketURI;
    private String[] mWebSocketSubprotocols;
    private WeakReference<WebSocket.WebSocketConnectionObserver> mWebSocketConnectionObserver;
    private WebSocketOptions mWebSocketOptions;
    private boolean mPreviousConnection = false;

    public WebSocketConnection() {
        LogUtils.DLog((String)TAG, (String)"WebSocket connection created.");
        this.mHandler = new ThreadHandler(this);
    }

    public WebSocketConnection(Context context) {
        this.mContext = context;
        this.mHandler = new ThreadHandler(this);
    }

    @Override
    public void sendTextMessage(String payload) {
        if (this.mWebSocketWriter != null) {
            this.mWebSocketWriter.forward(new WebSocketMessage.TextMessage(payload));
        }
    }

    @Override
    public void sendRawTextMessage(byte[] payload) {
        if (this.mWebSocketWriter != null) {
            this.mWebSocketWriter.forward(new WebSocketMessage.RawTextMessage(payload));
        }
    }

    @Override
    public void sendBinaryMessage(byte[] payload) {
        if (this.mWebSocketWriter != null) {
            this.mWebSocketWriter.forward(new WebSocketMessage.BinaryMessage(payload));
        }
    }

    @Override
    public boolean isConnected() {
        return this.mSocket != null && this.mSocket.isConnected() && !this.mSocket.isClosed();
    }

    private void failConnection(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification code, String reason) {
        LogUtils.DLog((String)TAG, (String)("fail connection [code = " + (Object)((Object)code) + ", reason = " + reason));
        if (this.mWebSocketReader != null && this.mWebSocketReader.isAlive()) {
            this.mWebSocketReader.quit();
            try {
                this.mWebSocketReader.join();
            }
            catch (InterruptedException var5) {
                var5.printStackTrace();
            }
        } else {
            LogUtils.DLog((String)TAG, (String)"mReader already NULL");
            this.onClose(code, reason);
            LogUtils.DLog((String)TAG, (String)"worker threads stopped");
            return;
        }
        if (this.mWebSocketWriter != null && this.mWebSocketWriter.isAlive()) {
            if (this.mWebSocketWriter.forward(new WebSocketMessage.Quit())) {
                try {
                    this.mWebSocketWriter.join();
                }
                catch (InterruptedException var4) {
                    var4.printStackTrace();
                }
            }
        } else {
            LogUtils.DLog((String)TAG, (String)"mWriter already NULL");
            this.onClose(code, reason);
            return;
        }
        if (this.mSocket == null || this.mSocketThread.getHandler() == null || !this.mSocketThread.isAlive()) {
            LogUtils.DLog((String)TAG, (String)"mTransportChannel already NULL");
            this.onClose(code, reason);
            LogUtils.DLog((String)TAG, (String)"worker threads stopped");
            return;
        }
        this.mSocketThread.getHandler().post(new Runnable(){

            @Override
            public void run() {
                WebSocketConnection.this.mSocketThread.stopConnection();
            }
        });
        if (this.mSocket != null && this.mSocketThread.getHandler() != null) {
            this.mSocketThread.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    Looper.myLooper().quit();
                }
            });
        }
        this.onClose(code, reason);
        LogUtils.DLog((String)TAG, (String)"worker threads stopped");
    }

    @Override
    public void connect(URI webSocketURI, WebSocket.WebSocketConnectionObserver connectionObserver) throws WebSocketException {
        this.connect(webSocketURI, connectionObserver, new WebSocketOptions());
    }

    @Override
    public void connect(URI webSocketURI, WebSocket.WebSocketConnectionObserver connectionObserver, WebSocketOptions options) throws WebSocketException {
        this.connect(webSocketURI, null, connectionObserver, options);
    }

    public void connect(URI webSocketURI, String[] subprotocols, WebSocket.WebSocketConnectionObserver connectionObserver, WebSocketOptions options) throws WebSocketException {
        if (this.isConnected()) {
            throw new WebSocketException("already connected");
        }
        if (webSocketURI == null) {
            throw new WebSocketException("WebSockets URI null.");
        }
        this.mWebSocketURI = webSocketURI;
        if (!this.mWebSocketURI.getScheme().equals(WS_URI_SCHEME) && !this.mWebSocketURI.getScheme().equals(WSS_URI_SCHEME)) {
            throw new WebSocketException("unsupported scheme for WebSockets URI");
        }
        this.mWebSocketSubprotocols = subprotocols;
        this.mWebSocketConnectionObserver = new WeakReference<WebSocket.WebSocketConnectionObserver>(connectionObserver);
        this.mWebSocketOptions = new WebSocketOptions(options);
        this.connect();
    }

    @Override
    public void disconnect() {
        if (this.mWebSocketWriter != null && this.mWebSocketWriter.isAlive()) {
            this.mWebSocketWriter.forward(new WebSocketMessage.Close());
        } else {
            LogUtils.DLog((String)TAG, (String)"Could not send WebSocket Close .. writer already null");
        }
        this.mPreviousConnection = false;
    }

    public boolean reconnect() {
        if (!this.isConnected() && this.mWebSocketURI != null) {
            this.connect();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        this.mSocketThread = new SocketThread(this.mWebSocketURI, this.mWebSocketOptions);
        this.mSocketThread.setContext(this.mContext);
        this.mSocketThread.start();
        SocketThread var1 = this.mSocketThread;
        SocketThread socketThread = this.mSocketThread;
        synchronized (socketThread) {
            try {
                this.mSocketThread.wait();
            }
            catch (InterruptedException var6) {
                var6.printStackTrace();
                LogUtils.ELog((String)TAG, (String)("mSocketThread  wait ...ex: " + var6.getLocalizedMessage()));
            }
        }
        LogUtils.ELog((String)TAG, (String)"thread notify ...");
        if (this.mSocketThread.getHandler() != null) {
            this.mSocketThread.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    try {
                        LogUtils.ELog((String)TAG, (String)"mSocketThread start connect ...");
                        WebSocketConnection.this.mSocketThread.startConnection();
                    }
                    catch (Exception ex) {
                        WebSocketConnection.this.mSocketThread.notifyAll();
                        LogUtils.ELog((String)TAG, (String)("mSocketThread start connect ...ex: " + ex.getLocalizedMessage()));
                    }
                }
            });
        }
        socketThread = this.mSocketThread;
        synchronized (socketThread) {
            try {
                this.mSocketThread.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.mSocket = this.mSocketThread.getSocket();
        if (this.mSocket == null) {
            if (NetUtils.isNetworkAvailable((Context)this.mContext)) {
                this.onClose(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.CANNOT_CONNECT, this.mSocketThread.getFailureMessage());
            } else {
                WebSocket.WebSocketConnectionObserver observer = (WebSocket.WebSocketConnectionObserver)this.mWebSocketConnectionObserver.get();
                if (observer != null) {
                    observer.onError(new Exception("No available network"));
                }
            }
        } else if (this.mSocket.isConnected()) {
            try {
                this.createReader();
                this.createWriter();
                WebSocketMessage.ClientHandshake clientHandshake = new WebSocketMessage.ClientHandshake(this.mWebSocketURI, null, this.mWebSocketSubprotocols);
                this.mWebSocketWriter.forward(clientHandshake);
            }
            catch (Exception var3) {
                this.onClose(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.INTERNAL_ERROR, var3.getLocalizedMessage());
            }
        } else {
            this.onClose(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.CANNOT_CONNECT, "could not connect to WebSockets server");
        }
    }

    protected boolean scheduleReconnect() {
        boolean shouldReconnect;
        int interval = this.mWebSocketOptions.getReconnectInterval();
        boolean bl = shouldReconnect = this.mSocket != null && this.mSocket.isConnected() && this.mPreviousConnection && interval > 0;
        if (shouldReconnect) {
            LogUtils.DLog((String)TAG, (String)"WebSocket reconnection scheduled");
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    LogUtils.DLog((String)TAG, (String)"WebSocket reconnecting...");
                    WebSocketConnection.this.reconnect();
                }
            }, (long)interval);
        }
        return shouldReconnect;
    }

    private void onClose(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification code, String reason) {
        block7: {
            WebSocket.WebSocketConnectionObserver webSocketObserver;
            boolean reconnecting = false;
            if (code == WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.CANNOT_CONNECT || code == WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.CONNECTION_LOST) {
                reconnecting = this.scheduleReconnect();
            }
            if ((webSocketObserver = (WebSocket.WebSocketConnectionObserver)this.mWebSocketConnectionObserver.get()) != null) {
                try {
                    if (reconnecting) {
                        webSocketObserver.onClose(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.RECONNECT, reason);
                        break block7;
                    }
                    webSocketObserver.onError(new Exception(reason));
                }
                catch (Exception var6) {
                    var6.printStackTrace();
                    webSocketObserver.onError(var6);
                }
            } else {
                LogUtils.DLog((String)TAG, (String)"WebSocketObserver null");
                assert (webSocketObserver != null);
                webSocketObserver.onError(new Exception("WebSocketObserver is null"));
            }
        }
    }

    protected void processAppMessage(Object message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createWriter() {
        this.mWebSocketWriter = new WebSocketWriter(this.mHandler, this.mSocket, this.mWebSocketOptions, WS_WRITER);
        this.mWebSocketWriter.start();
        WebSocketWriter var1 = this.mWebSocketWriter;
        WebSocketWriter webSocketWriter = this.mWebSocketWriter;
        synchronized (webSocketWriter) {
            try {
                this.mWebSocketWriter.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        LogUtils.DLog((String)TAG, (String)"WebSocket writer created and started.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createReader() {
        this.mWebSocketReader = new WebSocketReader(this.mHandler, this.mSocket, this.mWebSocketOptions, WS_READER);
        this.mWebSocketReader.start();
        WebSocketReader var1 = this.mWebSocketReader;
        WebSocketReader webSocketReader = this.mWebSocketReader;
        synchronized (webSocketReader) {
            try {
                this.mWebSocketReader.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        LogUtils.DLog((String)TAG, (String)"WebSocket reader created and started.");
    }

    private void handleMessage(Message message) {
        WebSocket.WebSocketConnectionObserver webSocketObserver = (WebSocket.WebSocketConnectionObserver)this.mWebSocketConnectionObserver.get();
        if (message.obj instanceof WebSocketMessage.TextMessage) {
            WebSocketMessage.TextMessage textMessage = (WebSocketMessage.TextMessage)message.obj;
            if (webSocketObserver != null) {
                webSocketObserver.onTextMessage(textMessage.mPayload);
            } else {
                LogUtils.DLog((String)TAG, (String)"could not call onTextMessage() .. handler already NULL");
            }
        } else if (message.obj instanceof WebSocketMessage.RawTextMessage) {
            WebSocketMessage.RawTextMessage rawTextMessage = (WebSocketMessage.RawTextMessage)message.obj;
            if (webSocketObserver != null) {
                webSocketObserver.onRawTextMessage(rawTextMessage.mPayload);
            } else {
                LogUtils.DLog((String)TAG, (String)"could not call onRawTextMessage() .. handler already NULL");
            }
        } else if (message.obj instanceof WebSocketMessage.BinaryMessage) {
            WebSocketMessage.BinaryMessage binaryMessage = (WebSocketMessage.BinaryMessage)message.obj;
            if (webSocketObserver != null) {
                webSocketObserver.onBinaryMessage(binaryMessage.mPayload);
            } else {
                LogUtils.DLog((String)TAG, (String)"could not call onBinaryMessage() .. handler already NULL");
            }
        } else if (message.obj instanceof WebSocketMessage.Ping) {
            WebSocketMessage.Ping ping = (WebSocketMessage.Ping)message.obj;
            LogUtils.DLog((String)TAG, (String)"WebSockets Ping received");
            WebSocketMessage.Pong pong = new WebSocketMessage.Pong();
            pong.mPayload = ping.mPayload;
            this.mWebSocketWriter.forward(pong);
        } else if (message.obj instanceof WebSocketMessage.Pong) {
            WebSocketMessage.Pong pong = (WebSocketMessage.Pong)message.obj;
            LogUtils.DLog((String)TAG, (String)("WebSockets Pong received" + Arrays.toString(pong.mPayload)));
        } else if (message.obj instanceof WebSocketMessage.Close) {
            WebSocketMessage.Close close = (WebSocketMessage.Close)message.obj;
            LogUtils.DLog((String)TAG, (String)("WebSockets Close received (" + close.getCode() + " - " + close.getReason() + ")"));
            this.mWebSocketWriter.forward(new WebSocketMessage.Close(1000));
        } else if (message.obj instanceof WebSocketMessage.ServerHandshake) {
            WebSocketMessage.ServerHandshake serverHandshake = (WebSocketMessage.ServerHandshake)message.obj;
            LogUtils.DLog((String)TAG, (String)"opening handshake received");
            if (serverHandshake.mSuccess) {
                if (webSocketObserver != null) {
                    webSocketObserver.onOpen();
                } else {
                    LogUtils.DLog((String)TAG, (String)"could not call onOpen() .. handler already NULL");
                }
                this.mPreviousConnection = true;
            }
        } else if (message.obj instanceof WebSocketMessage.ConnectionLost) {
            this.failConnection(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.CONNECTION_LOST, "WebSockets connection lost");
        } else if (message.obj instanceof WebSocketMessage.ProtocolViolation) {
            this.failConnection(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.PROTOCOL_ERROR, "WebSockets protocol violation");
        } else if (message.obj instanceof WebSocketMessage.Error) {
            WebSocketMessage.Error error = (WebSocketMessage.Error)message.obj;
            this.failConnection(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.INTERNAL_ERROR, "WebSockets internal error (" + error.mException.toString() + ")");
        } else if (message.obj instanceof WebSocketMessage.ServerError) {
            WebSocketMessage.ServerError error = (WebSocketMessage.ServerError)message.obj;
            this.failConnection(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.SERVER_ERROR, "Server error " + error.mStatusCode + " (" + error.mStatusMessage + ")");
        } else {
            this.processAppMessage(message.obj);
        }
    }

    private static class ThreadHandler
    extends Handler {
        private final WeakReference<WebSocketConnection> mWebSocketConnection;

        public ThreadHandler(WebSocketConnection webSocketConnection) {
            this.mWebSocketConnection = new WeakReference<WebSocketConnection>(webSocketConnection);
        }

        public void handleMessage(Message message) {
            WebSocketConnection webSocketConnection = (WebSocketConnection)this.mWebSocketConnection.get();
            if (webSocketConnection != null) {
                webSocketConnection.handleMessage(message);
            }
        }
    }
}

