/*
 * Decompiled with CFR 0.152.
 */
package de.tavendo.autobahn;

import de.tavendo.autobahn.WebSocketException;
import java.net.URI;

public class WebSocketMessage {

    public static class WebSocketCloseCode {
        public static final int NORMAL = 1000;
        public static final int ENDPOINT_GOING_AWAY = 1001;
        public static final int ENDPOINT_PROTOCOL_ERROR = 1002;
        public static final int ENDPOINT_UNSUPPORTED_DATA_TYPE = 1003;
        public static final int RESERVED = 1004;
        public static final int RESERVED_NO_STATUS = 1005;
        public static final int RESERVED_NO_CLOSING_HANDSHAKE = 1006;
        public static final int ENDPOINT_BAD_DATA = 1007;
        public static final int POLICY_VIOLATION = 1008;
        public static final int MESSAGE_TOO_BIG = 1009;
        public static final int ENDPOINT_NEEDS_EXTENSION = 1010;
        public static final int UNEXPECTED_CONDITION = 1011;
        public static final int RESERVED_TLS_REQUIRED = 1015;
    }

    public static class TextMessage
    extends Message {
        public String mPayload;

        TextMessage(String payload) {
            this.mPayload = payload;
        }
    }

    public static class ServerHandshake
    extends Message {
        public boolean mSuccess;

        public ServerHandshake(boolean success) {
            this.mSuccess = success;
        }
    }

    public static class ServerError
    extends Message {
        public int mStatusCode;
        public String mStatusMessage;

        public ServerError(int statusCode, String statusMessage) {
            this.mStatusCode = statusCode;
            this.mStatusMessage = statusMessage;
        }
    }

    public static class RawTextMessage
    extends Message {
        public byte[] mPayload;

        RawTextMessage(byte[] payload) {
            this.mPayload = payload;
        }
    }

    public static class Quit
    extends Message {
    }

    public static class ProtocolViolation
    extends Message {
        public WebSocketException mException;

        public ProtocolViolation(WebSocketException e) {
            this.mException = e;
        }
    }

    public static class Pong
    extends Message {
        public byte[] mPayload;

        Pong() {
            this.mPayload = null;
        }

        Pong(byte[] payload) {
            this.mPayload = payload;
        }
    }

    public static class Ping
    extends Message {
        public byte[] mPayload;

        Ping() {
            this.mPayload = null;
        }

        Ping(byte[] payload) {
            this.mPayload = payload;
        }
    }

    public static class Message {
    }

    public static class Error
    extends Message {
        public Exception mException;

        public Error(Exception e) {
            this.mException = e;
        }
    }

    public static class ConnectionLost
    extends Message {
    }

    public static class Close
    extends Message {
        private int mCode;
        private String mReason;

        Close() {
            this.mCode = 1011;
            this.mReason = null;
        }

        Close(int code) {
            this.mCode = code;
            this.mReason = null;
        }

        Close(int code, String reason) {
            this.mCode = code;
            this.mReason = reason;
        }

        public int getCode() {
            return this.mCode;
        }

        public String getReason() {
            return this.mReason;
        }
    }

    public static class ClientHandshake
    extends Message {
        private final URI mURI;
        private final URI mOrigin;
        private final String[] mSubprotocols;

        ClientHandshake(URI uri) {
            this.mURI = uri;
            this.mOrigin = null;
            this.mSubprotocols = null;
        }

        ClientHandshake(URI uri, URI origin, String[] subprotocols) {
            this.mURI = uri;
            this.mOrigin = origin;
            this.mSubprotocols = subprotocols;
        }

        public URI getURI() {
            return this.mURI;
        }

        public URI getOrigin() {
            return this.mOrigin;
        }

        public String[] getSubprotocols() {
            return this.mSubprotocols;
        }
    }

    public static class BinaryMessage
    extends Message {
        public byte[] mPayload;

        BinaryMessage(byte[] payload) {
            this.mPayload = payload;
        }
    }
}

