/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business;

import com.xdja.poc.sdk.bean.GroupList;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.business.MessageProxy;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import com.xdja.poc.sdk.event.GroupDeleteEvent;
import com.xdja.poc.sdk.event.GroupEvent;
import com.xdja.poc.sdk.event.GroupMemberAddEvent;
import com.xdja.poc.sdk.event.GroupRefreshAdapterEvent;
import com.xdja.poc.sdk.event.POCCallEvent;
import com.xdja.poc.sdk.event.POCChannelInfoResult;
import com.xdja.poc.sdk.event.POCGroupUpdateEvent;
import com.xdja.poc.sdk.event.ResetChannelStatus;
import com.xdja.poc.sdk.event.UpdateMemberInfoEvent;
import com.xdja.poc.sdk.event.UpdateUserInfoEvent;
import com.xdja.poc.sdk.proxy.POCUiKitProxyImpl;
import java.util.ArrayList;
import java.util.Map;
import org.greenrobot.eventbus.EventBus;

public class EventPropxy {
    public static void postUpdateGroupListData(ArrayList<GroupList.GroupData> mGroupList, int viewType, boolean isReconect) {
        POCGroupUpdateEvent updateEvent = new POCGroupUpdateEvent(mGroupList);
        updateEvent.setViewType(viewType);
        updateEvent.setReconnect(isReconect);
        updateEvent.setGroupType(0);
        EventBus.getDefault().post((Object)updateEvent);
    }

    public static void postDoRefreshChannelListData(int currentPage, int pageSize, int groupType) {
        POCUiKitProxyImpl.getInstance().notifyRefreshGroupList(currentPage, pageSize, groupType);
    }

    public static void postRefreshAdapter(String roomId) {
        GroupRefreshAdapterEvent adapterEvent = new GroupRefreshAdapterEvent();
        adapterEvent.setRoomId(roomId);
        EventBus.getDefault().post((Object)adapterEvent);
    }

    @Deprecated
    public static void postDeleteRoom(DBGroupEntity entity) {
        GroupDeleteEvent deleteEvent = new GroupDeleteEvent();
        deleteEvent.setT(entity);
        EventBus.getDefault().post((Object)deleteEvent);
    }

    public static void postChannelDeleted(int code, int position, String roomId, String from) {
        GroupEvent groupEvent = MessageProxy.generateGroupEvent(code, position, roomId, 3003, "", null);
        groupEvent.setFrom(from);
        POCUiKitProxyImpl.getInstance().notifyServerRoomDeleted(groupEvent, code == 200);
    }

    public static void postChannelRemoveMembers(String from, String roomId, String members) {
        GroupEvent groupEvent = MessageProxy.generateGroupEvent(200, -1, roomId, 3005, members, null);
        groupEvent.setFrom(from);
        POCUiKitProxyImpl.getInstance().notifyRemoveMembers(groupEvent, true);
    }

    public static void postAddMembers(String roomId, String[] members) {
        GroupMemberAddEvent addEvent = new GroupMemberAddEvent();
        addEvent.setRoomId(roomId);
        addEvent.setMemberIds(members);
        EventBus.getDefault().post((Object)addEvent);
    }

    public static void postChannelMemberAdded(int code, int position, String roomId, String memberIds, Map<String, POCMemberInfo> userInfos) {
        GroupEvent groupEvent = MessageProxy.generateGroupEvent(code, -1, roomId, 3004, memberIds, userInfos);
        POCUiKitProxyImpl.getInstance().notifyAddMembers(groupEvent, code == 200);
    }

    public static void postChannelMembersUpdate(int code, int position, String roomId, String memberIds) {
        GroupEvent groupEvent = MessageProxy.generateGroupEvent(code, -1, roomId, 3005, memberIds, null);
        POCUiKitProxyImpl.getInstance().notifyUpdateMembers(groupEvent, code == 200);
    }

    public static void postSetPttKey(String channelId, boolean pttStatus) {
        POCUiKitProxyImpl.getInstance().notifyPttKeyEvent(channelId, pttStatus);
    }

    public static void postUpdateChannelName(String channelId, String channelName) {
        POCUiKitProxyImpl.getInstance().notifyChannelNameEvent(channelId, channelName);
    }

    public static void postUpdateChannelPwdCode(String channelId, String channelPwd) {
        POCUiKitProxyImpl.getInstance().notifyChannelPwqEvent(channelId, channelPwd);
    }

    public static void postUpdateChannelPwdMode(String channelId, boolean channelPwdMode) {
        POCUiKitProxyImpl.getInstance().notifyChannelPwdModeEvent(channelId, channelPwdMode);
    }

    public static void postNotifyCallWaitingActivityResult(boolean result) {
        POCUiKitProxyImpl.getInstance().notifyChannelInfoResult(result);
        EventBus.getDefault().post((Object)new POCChannelInfoResult(result));
    }

    public static void postUpdateMembersInfo(DBGroupEntity entity, boolean isChannelExist) {
        UpdateMemberInfoEvent updateMemberInfoEvent = new UpdateMemberInfoEvent(entity);
        updateMemberInfoEvent.setChannelExist(isChannelExist);
        EventBus.getDefault().post((Object)updateMemberInfoEvent);
    }

    public static void postUpdateUserInfo(POCMemberInfo memberInfo) {
        EventBus.getDefault().post((Object)new UpdateUserInfoEvent(memberInfo));
    }

    public static void postPOCCallDelayEvent(String roomId, String userId) {
        POCCallEvent callEvent = new POCCallEvent();
        callEvent.setRoomId(roomId);
        callEvent.setUserId(userId);
        callEvent.setEventType(0);
        EventBus.getDefault().post((Object)callEvent);
    }

    public static void postPOCCallRejectEvent(String roomId, String userId) {
        POCCallEvent callEvent = new POCCallEvent();
        callEvent.setRoomId(roomId);
        callEvent.setUserId(userId);
        callEvent.setEventType(1);
        EventBus.getDefault().post((Object)callEvent);
    }

    public static void postResetChannelStatus(String channelId) {
        EventBus.getDefault().post((Object)new ResetChannelStatus(channelId));
    }
}

