/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business;

import android.content.Context;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.xdja.poc.common.utils.DeviceUtils;
import com.xdja.poc.common.utils.GlobalContext;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.sdk.POCClient;
import com.xdja.poc.sdk.bean.GroupList;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import com.xdja.poc.sdk.utils.GroupUtils;
import com.xdja.poc.sdk.utils.IPHost;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class POCGroupProxy {
    public static String DEVNO = "devNo";
    public static String DISPLAYNAME = "displayName";
    public static String GROUP_LEVEL = "groupLevel";
    public static String MAXINVITE_MEMBERSCOUNT = "maxInviteMembersCount";
    public static String MAX_TALKTIME = "maxTalkTime";
    public static String MEMBERS = "members";
    public static String HEAD_PORTRAIT = "headPortrait";
    public static String SIGN = "sign";
    public static String IS_HIDE = "isHide";
    public static String STATUS = "status";
    public static String GROUPURI = "groupUri";
    public static int INT_MAX_TALKTIME_DURATION = 60;
    public static int INT_MAXINVITE_MEMBERSCOUNT = 200;

    public static Map<String, String> generateCreateRoomData(String displayName, int groupLevel, String members, int maxMemberCount) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(DEVNO, PreferenceHelper.getString((String)"device_imei", (String)DeviceUtils.getImei((Context)GlobalContext.getContext())));
        map.put(DISPLAYNAME, displayName);
        map.put(GROUP_LEVEL, String.valueOf(groupLevel));
        map.put(MAXINVITE_MEMBERSCOUNT, String.valueOf(maxMemberCount));
        map.put(MAX_TALKTIME, String.valueOf(INT_MAX_TALKTIME_DURATION));
        map.put(MEMBERS, members);
        map.put(HEAD_PORTRAIT, "");
        map.put(SIGN, "create poc room");
        return map;
    }

    public static Map<String, String> generateDeleteRoomData(String roomId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(GROUPURI, String.valueOf(roomId));
        return map;
    }

    public static Map<String, String> generateAddMembersData(String roomId, String members) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(GROUPURI, String.valueOf(roomId));
        map.put(MEMBERS, members);
        return map;
    }

    public static Map<String, String> generateRemoveMembersData(String roomId, String members) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(GROUPURI, String.valueOf(roomId));
        map.put(MEMBERS, members);
        return map;
    }

    public static Map<String, String> generateUpdateMembersData(String roomId, String isHide, String status, int groupLevel, String members) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(GROUPURI, roomId);
        map.put(IS_HIDE, isHide);
        map.put(GROUP_LEVEL, String.valueOf(groupLevel));
        map.put(MAXINVITE_MEMBERSCOUNT, String.valueOf(INT_MAXINVITE_MEMBERSCOUNT));
        map.put(MAX_TALKTIME, String.valueOf(INT_MAX_TALKTIME_DURATION));
        map.put(HEAD_PORTRAIT, "");
        map.put(SIGN, "update poc room infos");
        map.put(STATUS, status);
        return map;
    }

    public static Map<String, String> generateJoinToChannelData(String channelId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(GROUPURI, String.valueOf(channelId));
        return map;
    }

    public static DBGroupEntity generateDBGroupEntity(String channelId, String userId, GroupList.GroupData groupData) {
        HashMap memberNameMaps = new HashMap();
        ArrayList<POCMemberInfo> memberInfoListTemp = new ArrayList<POCMemberInfo>();
        DBGroupEntity entity = new DBGroupEntity();
        entity.setRoomName(groupData.getDisplayName());
        entity.setMaxInviteMembersCount(StringUtils.isEmpty((String)groupData.getMaxInviteMembersCount()) ? 0 : Integer.valueOf(groupData.getMaxInviteMembersCount()));
        entity.setUserId(userId);
        entity.setRooomId(channelId);
        entity.setIsSilence(0);
        entity.setGroupType(0);
        entity.setOnLineCount(0);
        entity.setChannelPwdMode(groupData.getIsPassword().equals("Y") ? 1 : 0);
        entity.setChannelPwd(StringUtils.generateContent((String)groupData.getPassword()));
        entity.setKey(GroupUtils.generatePOCGroupDbKey(userId, channelId));
        entity.setOwnerId(groupData.getOwner());
        memberInfoListTemp.clear();
        List<GroupList.GroupMember> talkGroupMembers = groupData.getTalkGroupMembers();
        for (GroupList.GroupMember member : talkGroupMembers) {
            POCMemberInfo memberInfo_ = new POCMemberInfo();
            memberInfo_.setId(member.getMember());
            memberInfo_.setOnLine(false);
            memberInfo_.setRoomId(channelId);
            memberInfo_.setName(member.getName());
            memberInfo_.setAccount(member.getAccount());
            if (!TextUtils.isEmpty((CharSequence)member.getIcon())) {
                if (member.getIcon().startsWith("http")) {
                    memberInfo_.setIcon(member.getIcon());
                } else {
                    memberInfo_.setIcon(IPHost.getMisServer() + member.getIcon());
                }
            } else {
                memberInfo_.setIcon("");
            }
            memberInfoListTemp.add(memberInfo_);
        }
        if (memberInfoListTemp.size() > 0) {
            String s = POCClient.getInstance().generateListString(memberInfoListTemp);
            entity.setMemeberIds(s);
        }
        entity.setUserNames(new Gson().toJson(memberNameMaps));
        return entity;
    }
}

