/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business.webrtc.apprtc;

import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.business.webrtc.apprtc.AppRTCClient;
import com.xdja.poc.sdk.business.webrtc.apprtc.util.AsyncHttpURLConnection;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.IceCandidate;
import org.webrtc.PeerConnection;
import org.webrtc.SessionDescription;

public class RoomParametersFetcher {
    private static final String TAG = "RoomParametersFetcher";
    private static final int TURN_HTTP_TIMEOUT_MS = 5000;
    private final RoomParametersFetcherEvents events;
    private final String roomUrl;
    private final String roomMessage;

    public RoomParametersFetcher(String roomUrl, String roomMessage, RoomParametersFetcherEvents events) {
        this.roomUrl = roomUrl;
        this.roomMessage = roomMessage;
        this.events = events;
    }

    public void makeRequest() {
        LogUtils.DLog((String)TAG, (String)("Connecting to room: " + this.roomUrl));
        AsyncHttpURLConnection httpConnection = new AsyncHttpURLConnection("POST", this.roomUrl, this.roomMessage, new AsyncHttpURLConnection.AsyncHttpEvents(){

            @Override
            public void onHttpError(String errorMessage) {
                LogUtils.ELog((String)RoomParametersFetcher.TAG, (String)("Room connection error: " + errorMessage));
                RoomParametersFetcher.this.events.onSignalingParametersError(errorMessage);
            }

            @Override
            public void onHttpComplete(String response) {
                RoomParametersFetcher.this.roomHttpResponseParse(response);
            }
        });
        httpConnection.send();
    }

    private void roomHttpResponseParse(String response) {
        LogUtils.DLog((String)TAG, (String)("Room response: " + response));
        try {
            ArrayList<IceCandidate> iceCandidates = null;
            SessionDescription offerSdp = null;
            JSONObject roomJson = new JSONObject(response);
            String result = roomJson.getString("result");
            if (!result.equals("SUCCESS")) {
                this.events.onSignalingParametersError("Room response error: " + result);
                return;
            }
            response = roomJson.getString("params");
            roomJson = new JSONObject(response);
            String roomId = roomJson.getString("room_id");
            String clientId = roomJson.getString("client_id");
            String wssUrl = roomJson.getString("wss_url");
            String wssPostUrl = roomJson.getString("wss_post_url");
            boolean initiator = roomJson.getBoolean("is_initiator");
            if (!initiator) {
                iceCandidates = new ArrayList<IceCandidate>();
                String messagesString = roomJson.getString("messages");
                JSONArray messages = new JSONArray(messagesString);
                for (int i = 0; i < messages.length(); ++i) {
                    String messageString = messages.getString(i);
                    JSONObject message = new JSONObject(messageString);
                    String messageType = message.getString("type");
                    LogUtils.DLog((String)TAG, (String)("GAE->C #" + i + " : " + messageString));
                    if (messageType.equals("offer")) {
                        offerSdp = new SessionDescription(SessionDescription.Type.fromCanonicalForm((String)messageType), message.getString("sdp"));
                        continue;
                    }
                    if (messageType.equals("candidate")) {
                        IceCandidate candidate = new IceCandidate(message.getString("id"), message.getInt("label"), message.getString("candidate"));
                        iceCandidates.add(candidate);
                        continue;
                    }
                    LogUtils.ELog((String)TAG, (String)("Unknown message: " + messageString));
                }
            }
            LogUtils.DLog((String)TAG, (String)("RoomId: " + roomId + ". ClientId: " + clientId));
            LogUtils.DLog((String)TAG, (String)("Initiator: " + initiator));
            LogUtils.DLog((String)TAG, (String)("WSS url: " + wssUrl));
            LogUtils.DLog((String)TAG, (String)("WSS POST url: " + wssPostUrl));
            List<PeerConnection.IceServer> iceServers = this.iceServersFromPCConfigJSON(roomJson.getString("pc_config"));
            boolean isTurnPresent = false;
            block4: for (PeerConnection.IceServer server : iceServers) {
                LogUtils.DLog((String)TAG, (String)("IceServer: " + server));
                for (String uri : server.urls) {
                    if (!uri.startsWith("turn:")) continue;
                    isTurnPresent = true;
                    continue block4;
                }
            }
            if (!isTurnPresent && !roomJson.optString("ice_server_url").isEmpty()) {
                List<PeerConnection.IceServer> turnServers = this.requestTurnServers(roomJson.getString("ice_server_url"));
                for (PeerConnection.IceServer turnServer : turnServers) {
                    LogUtils.DLog((String)TAG, (String)("TurnServer: " + turnServer));
                    iceServers.add(turnServer);
                }
            }
            AppRTCClient.SignalingParameters params = new AppRTCClient.SignalingParameters(iceServers, initiator, clientId, wssUrl, wssPostUrl, offerSdp, iceCandidates);
            this.events.onSignalingParametersReady(params);
        }
        catch (JSONException e) {
            this.events.onSignalingParametersError("Room JSON parsing error: " + e.toString());
        }
        catch (IOException e) {
            this.events.onSignalingParametersError("Room IO error: " + e.toString());
        }
    }

    private List<PeerConnection.IceServer> requestTurnServers(String url) throws IOException, JSONException {
        ArrayList<PeerConnection.IceServer> turnServers = new ArrayList<PeerConnection.IceServer>();
        LogUtils.DLog((String)TAG, (String)("Request TURN from: " + url));
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setDoOutput(true);
        connection.setRequestProperty("REFERER", "http://192.168.105.169:8080");
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            throw new IOException("Non-200 response when requesting TURN server from " + url + " : " + connection.getHeaderField(null));
        }
        InputStream responseStream = connection.getInputStream();
        String response = RoomParametersFetcher.drainStream(responseStream);
        connection.disconnect();
        LogUtils.DLog((String)TAG, (String)("TURN response: " + response));
        JSONObject responseJSON = new JSONObject(response);
        JSONArray iceServers = responseJSON.getJSONArray("iceServers");
        for (int i = 0; i < iceServers.length(); ++i) {
            JSONObject server = iceServers.getJSONObject(i);
            JSONArray turnUrls = server.getJSONArray("urls");
            String username = server.has("username") ? server.getString("username") : "";
            String credential = server.has("credential") ? server.getString("credential") : "";
            for (int j = 0; j < turnUrls.length(); ++j) {
                String turnUrl = turnUrls.getString(j);
                PeerConnection.IceServer turnServer = PeerConnection.IceServer.builder((String)turnUrl).setUsername(username).setPassword(credential).createIceServer();
                turnServers.add(turnServer);
            }
        }
        return turnServers;
    }

    private List<PeerConnection.IceServer> iceServersFromPCConfigJSON(String pcConfig) throws JSONException {
        JSONObject json = new JSONObject(pcConfig);
        JSONArray servers = json.getJSONArray("iceServers");
        ArrayList<PeerConnection.IceServer> ret = new ArrayList<PeerConnection.IceServer>();
        for (int i = 0; i < servers.length(); ++i) {
            JSONObject server = servers.getJSONObject(i);
            String url = server.getString("urls");
            String credential = server.has("credential") ? server.getString("credential") : "";
            PeerConnection.IceServer turnServer = PeerConnection.IceServer.builder((String)url).setPassword(credential).createIceServer();
            ret.add(turnServer);
        }
        return ret;
    }

    private static String drainStream(InputStream in) {
        Scanner s = new Scanner(in, "UTF-8").useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public static interface RoomParametersFetcherEvents {
        public void onSignalingParametersReady(AppRTCClient.SignalingParameters var1);

        public void onSignalingParametersError(String var1);
    }
}

