/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business.webrtc.apprtc;

import android.util.Log;
import com.xdja.poc.common.utils.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;
import org.webrtc.ThreadUtils;

public class TCPChannelClient {
    private static final String TAG = "TCPChannelClient";
    private final ExecutorService executor;
    private final ThreadUtils.ThreadChecker executorThreadCheck;
    private final TCPChannelEvents eventListener;
    private TCPSocket socket;

    public TCPChannelClient(ExecutorService executor, TCPChannelEvents eventListener, String ip, int port) {
        InetAddress address;
        this.executor = executor;
        this.executorThreadCheck = new ThreadUtils.ThreadChecker();
        this.executorThreadCheck.detachThread();
        this.eventListener = eventListener;
        try {
            address = InetAddress.getByName(ip);
        }
        catch (UnknownHostException e) {
            this.reportError("Invalid IP address.");
            return;
        }
        this.socket = address.isAnyLocalAddress() ? new TCPSocketServer(address, port) : new TCPSocketClient(address, port);
        this.socket.start();
    }

    public void disconnect() {
        this.executorThreadCheck.checkIsOnValidThread();
        this.socket.disconnect();
    }

    public void send(String message) {
        this.executorThreadCheck.checkIsOnValidThread();
        this.socket.send(message);
    }

    private void reportError(final String message) {
        LogUtils.ELog((String)TAG, (String)("TCP Error: " + message));
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                TCPChannelClient.this.eventListener.onTCPError(message);
            }
        });
    }

    private class TCPSocketClient
    extends TCPSocket {
        private final InetAddress address;
        private final int port;

        public TCPSocketClient(InetAddress address, int port) {
            this.address = address;
            this.port = port;
        }

        @Override
        public Socket connect() {
            LogUtils.DLog((String)TCPChannelClient.TAG, (String)("Connecting to [" + this.address.getHostAddress() + "]:" + Integer.toString(this.port)));
            try {
                return new Socket(this.address, this.port);
            }
            catch (IOException e) {
                TCPChannelClient.this.reportError("Failed to connect: " + e.getMessage());
                return null;
            }
        }

        @Override
        public boolean isServer() {
            return false;
        }
    }

    private class TCPSocketServer
    extends TCPSocket {
        private ServerSocket serverSocket;
        private final InetAddress address;
        private final int port;

        public TCPSocketServer(InetAddress address, int port) {
            this.address = address;
            this.port = port;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Socket connect() {
            ServerSocket tempSocket;
            LogUtils.DLog((String)TCPChannelClient.TAG, (String)("Listening on [" + this.address.getHostAddress() + "]:" + Integer.toString(this.port)));
            try {
                tempSocket = new ServerSocket(this.port, 0, this.address);
            }
            catch (IOException e) {
                TCPChannelClient.this.reportError("Failed to create server socket: " + e.getMessage());
                return null;
            }
            Object e = this.rawSocketLock;
            synchronized (e) {
                if (this.serverSocket != null) {
                    LogUtils.ELog((String)TCPChannelClient.TAG, (String)"Server rawSocket was already listening and new will be opened.");
                }
                this.serverSocket = tempSocket;
            }
            try {
                return tempSocket.accept();
            }
            catch (IOException e2) {
                TCPChannelClient.this.reportError("Failed to receive connection: " + e2.getMessage());
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void disconnect() {
            try {
                Object object = this.rawSocketLock;
                synchronized (object) {
                    if (this.serverSocket != null) {
                        this.serverSocket.close();
                        this.serverSocket = null;
                    }
                }
            }
            catch (IOException e) {
                TCPChannelClient.this.reportError("Failed to close server socket: " + e.getMessage());
            }
            super.disconnect();
        }

        @Override
        public boolean isServer() {
            return true;
        }
    }

    private abstract class TCPSocket
    extends Thread {
        protected final Object rawSocketLock = new Object();
        private PrintWriter out;
        private Socket rawSocket;

        public abstract Socket connect();

        public abstract boolean isServer();

        TCPSocket() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufferedReader in;
            LogUtils.DLog((String)TCPChannelClient.TAG, (String)"Listening thread started...");
            Socket tempSocket = this.connect();
            LogUtils.DLog((String)TCPChannelClient.TAG, (String)"TCP connection established.");
            Object object = this.rawSocketLock;
            synchronized (object) {
                if (this.rawSocket != null) {
                    LogUtils.ELog((String)TCPChannelClient.TAG, (String)"Socket already existed and will be replaced.");
                }
                this.rawSocket = tempSocket;
                if (this.rawSocket == null) {
                    return;
                }
                try {
                    this.out = new PrintWriter((Writer)new OutputStreamWriter(this.rawSocket.getOutputStream(), Charset.forName("UTF-8")), true);
                    in = new BufferedReader(new InputStreamReader(this.rawSocket.getInputStream(), Charset.forName("UTF-8")));
                }
                catch (IOException e) {
                    TCPChannelClient.this.reportError("Failed to open IO on rawSocket: " + e.getMessage());
                    return;
                }
            }
            Log.v((String)TCPChannelClient.TAG, (String)"Execute onTCPConnected");
            TCPChannelClient.this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    Log.v((String)TCPChannelClient.TAG, (String)"Run onTCPConnected");
                    TCPChannelClient.this.eventListener.onTCPConnected(TCPSocket.this.isServer());
                }
            });
            while (true) {
                String message;
                try {
                    message = in.readLine();
                }
                catch (IOException e) {
                    Object object2 = this.rawSocketLock;
                    synchronized (object2) {
                        if (this.rawSocket == null) {
                            break;
                        }
                    }
                    TCPChannelClient.this.reportError("Failed to read from rawSocket: " + e.getMessage());
                    break;
                }
                if (message == null) break;
                TCPChannelClient.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        Log.v((String)TCPChannelClient.TAG, (String)("Receive: " + message));
                        TCPChannelClient.this.eventListener.onTCPMessage(message);
                    }
                });
            }
            LogUtils.DLog((String)TCPChannelClient.TAG, (String)"Receiving thread exiting...");
            this.disconnect();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnect() {
            try {
                Object object = this.rawSocketLock;
                synchronized (object) {
                    if (this.rawSocket != null) {
                        this.rawSocket.close();
                        this.rawSocket = null;
                        this.out = null;
                        TCPChannelClient.this.executor.execute(new Runnable(){

                            @Override
                            public void run() {
                                TCPChannelClient.this.eventListener.onTCPClose();
                            }
                        });
                    }
                }
            }
            catch (IOException e) {
                TCPChannelClient.this.reportError("Failed to close rawSocket: " + e.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(String message) {
            Log.v((String)TCPChannelClient.TAG, (String)("Send: " + message));
            Object object = this.rawSocketLock;
            synchronized (object) {
                if (this.out == null) {
                    TCPChannelClient.this.reportError("Sending data on closed socket.");
                    return;
                }
                this.out.write(message + "\n");
                this.out.flush();
            }
        }
    }

    public static interface TCPChannelEvents {
        public void onTCPConnected(boolean var1);

        public void onTCPMessage(String var1);

        public void onTCPError(String var1);

        public void onTCPClose();
    }
}

