/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business.webrtc.janusclientapi;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.business.webrtc.apprtc.AppRTCClient;
import com.xdja.poc.sdk.business.webrtc.apprtc.PeerConnectionClient;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IJanusPluginCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IPluginHandleSendMessageCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IPluginHandleWebRTCCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusMessageType;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusServer;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusSupportedPluginPackages;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.TransactionType;
import com.xdja.poc.sdk.utils.IPHost;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.Camera1Enumerator;
import org.webrtc.CameraEnumerator;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.EglBase;
import org.webrtc.IceCandidate;
import org.webrtc.Logging;
import org.webrtc.MediaStream;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.SessionDescription;
import org.webrtc.StatsReport;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoSink;

public class JanusPluginHandleWithWebrtc
implements AppRTCClient.SignalingEvents,
PeerConnectionClient.PeerConnectionEvents {
    public static String TAG = "JanusPluginHandle";
    private volatile PeerConnectionClient peerConnectionClient;
    private volatile boolean started = false;
    private volatile boolean userStop = false;
    private MediaStream myStream = null;
    private MediaStream remoteStream = null;
    String localSdp = null;
    String localSdpType = null;
    private boolean trickle = true;
    private boolean iceDone = false;
    private volatile boolean sdpSent = false;
    private int ice_candidate = 0;
    int candidateNum = 0;
    List<IceCandidate> localIceCandidates = new ArrayList<IceCandidate>();
    List<IceCandidate> remoteIceCandidatelist = new ArrayList<IceCandidate>();
    SessionDescription remoteSdp = null;
    private final JanusServer server;
    public final JanusSupportedPluginPackages plugin;
    public final BigInteger id;
    private final IJanusPluginCallbacks callbacks;
    private boolean bOfferFlag;
    VideoSink localVideoSink = null;
    VideoSink remoteVideoSink = null;
    IPluginHandleWebRTCCallbacks mCallbacks;

    @Override
    public void onConnectedToRoom(AppRTCClient.SignalingParameters params) {
    }

    @Override
    public void onRemoteDescription(SessionDescription sdp) {
    }

    @Override
    public void onRemoteIceCandidate(IceCandidate candidate) {
    }

    @Override
    public void onRemoteIceCandidatesRemoved(IceCandidate[] candidates) {
    }

    @Override
    public void onChannelClose() {
    }

    @Override
    public void onChannelError(String description) {
    }

    @Override
    public void onLocalDescription(SessionDescription sdp) {
        Log.v((String)TAG, (String)("On onLocalDescription  sdp :" + sdp.description));
        this.onLocalSdp(sdp, this.mCallbacks);
    }

    @Override
    public void onSetRemoteDescriptionSuccess() {
        if (this.localSdp == null) {
            this.createSdpInternal(this.mCallbacks, false);
        }
    }

    @Override
    public void onIceCandidate(IceCandidate candidate) {
        Log.i((String)TAG, (String)("Ice Gathering:" + candidate.toString()));
        this.sendTrickleCandidate(candidate);
        this.iceDone = true;
        this.sendSdp(this.mCallbacks);
    }

    @Override
    public void onIceCandidatesRemoved(IceCandidate[] candidates) {
    }

    @Override
    public void onIceConnected() {
        Log.i((String)TAG, (String)"onIceConnected Success");
        if (this.callbacks != null) {
            this.callbacks.onDataOpen(null);
        }
    }

    @Override
    public void onIceDisconnected() {
        Log.i((String)TAG, (String)"onIceDisconnected Success");
        if (this.callbacks != null) {
            if (this.userStop) {
                this.callbacks.onCleanup();
            } else {
                this.callbacks.onCallbackError("ICE connection failed");
            }
        }
    }

    @Override
    public void onPeerConnectionClosed() {
        Log.i((String)TAG, (String)"onPeerConnectionClosed Success");
        if (this.callbacks != null) {
            this.callbacks.onCleanup();
        }
    }

    @Override
    public void onPeerConnectionStatsReady(StatsReport[] reports) {
    }

    @Override
    public void onPeerConnectionError(String description) {
        if (this.callbacks != null) {
            this.callbacks.onCallbackError("connection failed");
        }
    }

    @Override
    public void onDataChannelRcvData(String rcv) {
        try {
            JSONObject obj = new JSONObject(rcv);
            if (this.callbacks != null) {
                this.callbacks.onData(obj);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void pause() {
        if (this.peerConnectionClient != null) {
            // empty if block
        }
    }

    public void resume() {
        if (this.peerConnectionClient != null) {
            // empty if block
        }
    }

    private VideoCapturer createCameraCapturer(CameraEnumerator enumerator) {
        CameraVideoCapturer videoCapturer;
        String[] deviceNames = enumerator.getDeviceNames();
        Logging.d((String)TAG, (String)"Looking for front facing cameras.");
        for (String deviceName : deviceNames) {
            if (!enumerator.isFrontFacing(deviceName)) continue;
            Logging.d((String)TAG, (String)"Creating front facing camera capturer.");
            videoCapturer = enumerator.createCapturer(deviceName, null);
            if (videoCapturer == null) continue;
            return videoCapturer;
        }
        Logging.d((String)TAG, (String)"Looking for other cameras.");
        for (String deviceName : deviceNames) {
            if (enumerator.isFrontFacing(deviceName)) continue;
            Logging.d((String)TAG, (String)"Creating other camera capturer.");
            videoCapturer = enumerator.createCapturer(deviceName, null);
            if (videoCapturer == null) continue;
            return videoCapturer;
        }
        return null;
    }

    private LinkedList<PeerConnection.IceServer> iceServersFromPCConfigJSON() {
        try {
            String stunServer = IPHost.getStunServer();
            String stunUrl = IPHost.getStunUrls();
            String iceServer = "{\"iceServers\": [{\"urls\": \"" + stunServer + "\"}, {\"urls\": \"" + stunUrl + "\", \"credential\": \"1234\"}]}";
            Log.i((String)TAG, (String)("iceServer:" + iceServer));
            JSONObject json = new JSONObject(iceServer);
            JSONArray servers = json.getJSONArray("iceServers");
            LinkedList<PeerConnection.IceServer> ret = new LinkedList<PeerConnection.IceServer>();
            for (int i = 0; i < servers.length(); ++i) {
                JSONObject server = servers.getJSONObject(i);
                Log.i((String)TAG, (String)("server:" + server.toString()));
                String url = server.getString("urls");
                String credential = server.has("credential") ? server.getString("credential") : "";
                PeerConnection.IceServer turnServer = PeerConnection.IceServer.builder((String)url).setPassword(credential).createIceServer();
                ret.add(turnServer);
            }
            return ret;
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("ex:" + ex.getMessage()));
            return new LinkedList<PeerConnection.IceServer>();
        }
    }

    public JanusPluginHandleWithWebrtc(JanusServer server, JanusSupportedPluginPackages plugin, BigInteger handle_id, IJanusPluginCallbacks callbacks, Context context, PeerConnectionClient.PeerConnectionParameters peerConnectionParameters, VideoSink localVideoSink, VideoSink remoteVideoSink, EglBase eglBase, boolean flag) {
        this.server = server;
        this.plugin = plugin;
        this.id = handle_id;
        this.callbacks = callbacks;
        this.localVideoSink = localVideoSink;
        this.remoteVideoSink = remoteVideoSink;
        if (flag) {
            this.peerConnectionClient = new PeerConnectionClient(context.getApplicationContext(), eglBase, peerConnectionParameters, this);
            PeerConnectionFactory.Options options = new PeerConnectionFactory.Options();
            options.networkIgnoreMask = 16;
            this.peerConnectionClient.createPeerConnectionFactory(options);
        }
    }

    public void onMessage(String msg) {
        try {
            JSONObject obj = new JSONObject(msg);
            this.callbacks.onMessage(obj, null);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void onMessage(JSONObject msg, JSONObject jsep) {
        this.callbacks.onMessage(msg, jsep);
    }

    private void onLocalStream(MediaStream stream) {
        this.callbacks.onLocalStream(stream);
    }

    private void onRemoteStream(MediaStream stream) {
        this.callbacks.onRemoteStream(stream);
    }

    public void onDataOpen(Object data) {
        this.callbacks.onDataOpen(data);
    }

    public void onData(Object data) {
        this.callbacks.onData(data);
    }

    public void onCleanup() {
        this.callbacks.onCleanup();
    }

    public void onDetached() {
        this.callbacks.onDetached();
    }

    public void sendMessage(IPluginHandleSendMessageCallbacks obj) {
        this.server.sendMessage(TransactionType.plugin_handle_message, this.id, obj, this.plugin);
    }

    public void createOffer(IPluginHandleWebRTCCallbacks webrtcCallbacks) {
        if (this.peerConnectionClient != null) {
            new AsyncPrepareWebRtc(this, true).execute(new IPluginHandleWebRTCCallbacks[]{webrtcCallbacks});
        }
    }

    public void createAnswer(IPluginHandleWebRTCCallbacks webrtcCallbacks) {
        if (this.peerConnectionClient != null) {
            new AsyncPrepareWebRtc(this, false).execute(new IPluginHandleWebRTCCallbacks[]{webrtcCallbacks});
        }
    }

    public void sendMsgOverDataChannel(String msg) {
        if (this.peerConnectionClient != null) {
            this.peerConnectionClient.sendDataWithChannel(msg);
        }
    }

    public void startPlayer(boolean enable) {
        LogUtils.ILog((String)(TAG + ":" + enable));
        if (this.peerConnectionClient != null) {
            this.peerConnectionClient.startPlayOut(enable);
        }
    }

    public void mute(boolean enable) {
        if (this.peerConnectionClient != null) {
            this.peerConnectionClient.mute(enable);
        }
    }

    public boolean getMuteState() {
        return this.peerConnectionClient == null || this.peerConnectionClient.getMuteState();
    }

    public void takenTBCP() {
        if (this.peerConnectionClient != null) {
            this.peerConnectionClient.setAudioEnabled(true);
        }
    }

    public void releaseTBCP() {
        if (this.peerConnectionClient != null) {
            this.peerConnectionClient.setAudioEnabled(false);
        }
    }

    private synchronized void prepareWebRtc(IPluginHandleWebRTCCallbacks callbacks, boolean bOfferFlg) {
        if (this.peerConnectionClient == null) {
            return;
        }
        if (callbacks.getMedia().getRecvVideo()) {
            Log.i((String)"VIDEO_ROOM", (String)"Receiving video");
        }
        VideoCapturer videoCapturer = null;
        if (callbacks.getMedia().getSendVideo()) {
            videoCapturer = this.createCameraCapturer((CameraEnumerator)new Camera1Enumerator(true));
        }
        if (callbacks.getJsep() != null) {
            try {
                JSONObject jsep = callbacks.getJsep();
                String sdpString = jsep.getString("sdp");
                Log.i((String)TAG, (String)("On jsep  sdp :" + sdpString));
                if (sdpString.contains("a=candidate")) {
                    String[] lines = sdpString.split("\r\n");
                    ArrayList codecPayloadTypes = new ArrayList();
                    int index = 0;
                    for (String line : lines) {
                        if (!line.contains("a=candidate:")) continue;
                        String data = line.substring(2);
                        try {
                            IceCandidate candidate = new IceCandidate("video", index++, data);
                            this.remoteIceCandidatelist.add(candidate);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                SessionDescription.Type type = SessionDescription.Type.fromCanonicalForm((String)jsep.getString("type"));
                this.remoteSdp = new SessionDescription(type, sdpString);
            }
            catch (JSONException jsep) {
                // empty catch block
            }
        }
        this.trickle = callbacks.getTrickle() != null ? callbacks.getTrickle() : false;
        AppRTCClient.SignalingParameters signalingParameters = new AppRTCClient.SignalingParameters(this.iceServersFromPCConfigJSON(), bOfferFlg, "", "", "", null, new ArrayList<IceCandidate>());
        this.peerConnectionClient.setVideoRecvFlag(callbacks.getMedia().getRecvVideo());
        this.peerConnectionClient.setAudioRecvFlag(callbacks.getMedia().getRecvAudio());
        if (callbacks.getRemoteSink() != null) {
            this.remoteVideoSink = callbacks.getRemoteSink();
        }
        this.started = true;
        this.peerConnectionClient.setAudioCodec(callbacks.getMedia().getAudioCodec());
        this.peerConnectionClient.createPeerConnection(this.localVideoSink, this.remoteVideoSink, videoCapturer, signalingParameters);
        if (callbacks.getMedia().getSendVideo()) {
            this.peerConnectionClient.setVideoEnabled(true);
        } else {
            this.peerConnectionClient.setVideoEnabled(false);
        }
        if (callbacks.getMedia().getSendAudio()) {
            this.peerConnectionClient.setAudioEnabled(true);
        } else {
            this.peerConnectionClient.setAudioEnabled(false);
        }
        this.peerConnectionClient.setAudioEnabled(false);
        this.peerConnectionClient.startPlayOut(false);
        this.mCallbacks = callbacks;
        if (this.remoteSdp == null) {
            this.createSdpInternal(callbacks, true);
        } else if (this.remoteSdp != null && this.remoteIceCandidatelist != null) {
            this.peerConnectionClient.setRemoteDescription(this.remoteSdp);
        }
    }

    private void createSdpInternal(IPluginHandleWebRTCCallbacks callbacks, Boolean isOffer) {
        this.mCallbacks = callbacks;
        if (isOffer.booleanValue()) {
            this.peerConnectionClient.createOffer();
        } else {
            this.peerConnectionClient.createAnswer();
        }
    }

    public void handleRemoteJsep(IPluginHandleWebRTCCallbacks webrtcCallbacks) {
        new AsyncHandleRemoteJsep(this).execute(new IPluginHandleWebRTCCallbacks[]{webrtcCallbacks});
    }

    public synchronized void hangUp() {
        if (!this.started) {
            return;
        }
        this.userStop = true;
        this.started = false;
        if (this.remoteStream != null) {
            this.remoteStream.dispose();
            this.remoteStream = null;
        }
        if (this.myStream != null) {
            this.myStream.dispose();
            this.myStream = null;
        }
        if (this.peerConnectionClient != null) {
            this.peerConnectionClient.close();
        }
        this.peerConnectionClient = null;
        this.localSdp = null;
        this.trickle = true;
        this.iceDone = false;
        this.sdpSent = false;
    }

    public void detach() {
        this.hangUp();
        JSONObject obj = new JSONObject();
        this.server.sendMessage(obj, JanusMessageType.detach, this.id);
    }

    private void onLocalSdp(SessionDescription sdp, IPluginHandleWebRTCCallbacks callbacks) {
        block9: {
            if (this.peerConnectionClient != null) {
                if (this.localSdp == null) {
                    this.localSdp = sdp.description;
                    this.localSdpType = sdp.type.canonicalForm();
                }
                if (!this.iceDone && !this.trickle) {
                    Log.e((String)TAG, (String)"onLocalSdp:false, trickle:false");
                    return;
                }
                if (this.sdpSent) {
                    return;
                }
                if (this.localIceCandidates.size() > 0) {
                    StringBuilder sb = new StringBuilder(this.localSdp);
                    for (IceCandidate candidate : this.localIceCandidates) {
                        sb.append("a=");
                        sb.append(candidate.sdp);
                        sb.append("\r\n");
                    }
                    sb.append("a=end-of-candidates");
                    sb.append("\r\n");
                    this.localSdp = sb.toString();
                }
                try {
                    this.sdpSent = true;
                    JSONObject obj = new JSONObject();
                    obj.put("sdp", (Object)this.localSdp);
                    obj.put("type", (Object)this.localSdpType);
                    if (null != callbacks) {
                        callbacks.onSuccess(obj);
                    }
                }
                catch (JSONException ex) {
                    if (null == callbacks) break block9;
                    callbacks.onCallbackError(ex.getMessage());
                }
            }
        }
    }

    private void sendTrickleCandidate(IceCandidate candidate) {
        try {
            JSONObject message = new JSONObject();
            JSONObject cand = new JSONObject();
            if (candidate == null) {
                cand.put("completed", true);
            } else {
                cand.put("candidate", (Object)candidate.sdp);
                cand.put("sdpMid", (Object)candidate.sdpMid);
                cand.put("sdpMLineIndex", candidate.sdpMLineIndex);
            }
            message.put("candidate", (Object)cand);
            this.server.sendMessage(message, JanusMessageType.trickle, this.id);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private void sendSdp(IPluginHandleWebRTCCallbacks callbacks) {
        block4: {
            if (this.localSdp != null && !this.sdpSent) {
                this.sdpSent = true;
                try {
                    JSONObject obj = new JSONObject();
                    obj.put("sdp", (Object)this.localSdp);
                    obj.put("type", (Object)this.localSdpType);
                    if (null != callbacks) {
                        callbacks.onSuccess(obj);
                    }
                }
                catch (JSONException ex) {
                    if (null == callbacks) break block4;
                    callbacks.onCallbackError(ex.getMessage());
                }
            }
        }
    }

    private static class AsyncHandleRemoteJsep
    extends AsyncTask<IPluginHandleWebRTCCallbacks, Void, Void> {
        private final WeakReference<JanusPluginHandleWithWebrtc> webrtcWeakReference;

        public AsyncHandleRemoteJsep(JanusPluginHandleWithWebrtc janusPluginHandleWithWebrtc) {
            this.webrtcWeakReference = new WeakReference<JanusPluginHandleWithWebrtc>(janusPluginHandleWithWebrtc);
        }

        protected Void doInBackground(IPluginHandleWebRTCCallbacks ... params) {
            if (this.webrtcWeakReference.get() != null) {
                JanusPluginHandleWithWebrtc janusPluginHandleWithWebrtc = (JanusPluginHandleWithWebrtc)this.webrtcWeakReference.get();
                IPluginHandleWebRTCCallbacks webrtcCallbacks = params[0];
                if (janusPluginHandleWithWebrtc.peerConnectionClient == null) {
                    webrtcCallbacks.onCallbackError("WebRtc PeerFactory is not initialized. Please call initializeMediaContext");
                    return null;
                }
                JSONObject jsep = webrtcCallbacks.getJsep();
                if (jsep != null) {
                    try {
                        String sdpString = jsep.getString("sdp");
                        Log.i((String)TAG, (String)("sdpString:" + sdpString));
                        SessionDescription.Type type = SessionDescription.Type.fromCanonicalForm((String)jsep.getString("type"));
                        SessionDescription sdp = new SessionDescription(type, sdpString);
                        janusPluginHandleWithWebrtc.peerConnectionClient.setRemoteDescription(sdp);
                    }
                    catch (JSONException ex) {
                        Log.i((String)TAG, (String)ex.getMessage());
                        webrtcCallbacks.onCallbackError(ex.getMessage());
                    }
                }
            }
            return null;
        }

        protected void onPostExecute(Void aVoid) {
            super.onPostExecute((Object)aVoid);
            LogUtils.ELog((String)"AsyncHandleRemoteJsep", (String)"cancel");
            try {
                this.cancel(true);
            }
            catch (Exception e) {
                LogUtils.ELog((Throwable)e);
            }
        }
    }

    private static class AsyncPrepareWebRtc
    extends AsyncTask<IPluginHandleWebRTCCallbacks, Void, Void> {
        private final WeakReference<JanusPluginHandleWithWebrtc> janusPluginHandleWithWebrtcWeakReference;

        public AsyncPrepareWebRtc(JanusPluginHandleWithWebrtc janusPluginHandleWithWebrtc, boolean offerFlg) {
            this.janusPluginHandleWithWebrtcWeakReference = new WeakReference<JanusPluginHandleWithWebrtc>(janusPluginHandleWithWebrtc);
            janusPluginHandleWithWebrtc.bOfferFlag = offerFlg;
        }

        protected Void doInBackground(IPluginHandleWebRTCCallbacks ... params) {
            if (this.janusPluginHandleWithWebrtcWeakReference.get() != null) {
                JanusPluginHandleWithWebrtc pluginHandleWithWebrtc = (JanusPluginHandleWithWebrtc)this.janusPluginHandleWithWebrtcWeakReference.get();
                IPluginHandleWebRTCCallbacks cb = params[0];
                pluginHandleWithWebrtc.prepareWebRtc(cb, pluginHandleWithWebrtc.bOfferFlag);
            }
            return null;
        }

        protected void onPostExecute(Void aVoid) {
            super.onPostExecute((Object)aVoid);
            LogUtils.ELog((String)"AsyncPrepareWebRtc", (String)"cancel");
            try {
                this.cancel(true);
            }
            catch (Exception e) {
                LogUtils.ELog((Throwable)e);
            }
        }
    }
}

