/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.greendao.manager;

import com.xdja.poc.common.utils.GlobalContext;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.sdk.greendao.dao.DaoMaster;
import com.xdja.poc.sdk.greendao.dao.DaoSession;
import com.xdja.poc.sdk.greendao.manager.SQLiteOpenHelper;
import org.greenrobot.greendao.database.Database;

public class GreenDaoManager {
    private static final String DB_NAME_SUFFIX = "_record.db";
    private static GreenDaoManager mInstance;
    private DaoMaster daoMaster;
    private DaoSession daoSession;
    private SQLiteOpenHelper mHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GreenDaoManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<GreenDaoManager> clazz = GreenDaoManager.class;
        synchronized (GreenDaoManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new GreenDaoManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private GreenDaoManager() {
        if (mInstance == null) {
            this.getDaoMaster();
        }
    }

    public DaoSession getDaoSession() {
        if (this.daoSession == null) {
            if (this.daoMaster == null) {
                this.daoMaster = this.getDaoMaster();
            }
            this.daoSession = this.daoMaster.newSession();
        }
        return this.daoSession;
    }

    public DaoMaster getDaoMaster() {
        if (this.daoMaster == null) {
            try {
                String account = PreferenceHelper.getString((String)"login_account", (String)"");
                String DB_NAME = account + DB_NAME_SUFFIX;
                LogUtils.ELog((String)DB_NAME, (String)DB_NAME);
                this.mHelper = new SQLiteOpenHelper(GlobalContext.getContext(), DB_NAME, null);
                Database db = this.mHelper.getWritableDb();
                this.daoMaster = new DaoMaster(db);
                return this.daoMaster;
            }
            catch (Exception e) {
                this.closeHelper();
                LogUtils.ELog((Throwable)e);
            }
        }
        return this.daoMaster;
    }

    public void resetDaoMaster() {
        this.closeConnection();
        this.daoMaster = null;
    }

    public void closeConnection() {
        this.closeHelper();
        this.closeDaoSession();
    }

    public void closeHelper() {
        if (this.mHelper != null) {
            this.mHelper.close();
            this.mHelper = null;
        }
    }

    public void closeDaoSession() {
        if (this.daoSession != null) {
            this.daoSession.clear();
            this.daoSession = null;
        }
    }
}

