/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.receiver;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import com.xdja.poc.common.R;
import com.xdja.poc.common.base.BaseActivity;
import com.xdja.poc.common.utils.GlobalContext;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.UiUtils;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.business.MessageProxy;
import com.xdja.poc.sdk.business.ringplay.RingPlayer;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.event.HomeOrRecentEvent;
import com.xdja.poc.sdk.manager.AMnager;
import org.greenrobot.eventbus.EventBus;

public class HomeKeyReceiver
extends BroadcastReceiver {
    static HomeKeyReceiver homeKeyReceiver = new HomeKeyReceiver();
    private static boolean isRegister = false;

    @SuppressLint(value={"ShowToast"})
    public void onReceive(Context context, Intent intent) {
        if (intent == null || TextUtils.isEmpty((CharSequence)intent.getAction())) {
            return;
        }
        switch (intent.getAction()) {
            case "android.intent.action.CLOSE_SYSTEM_DIALOGS": {
                String extra = intent.getStringExtra(Constants.SYSTEM_REASON);
                if (!BaseActivity.isSelfActivity || TextUtils.isEmpty((CharSequence)extra)) {
                    return;
                }
                if (Constants.SYSTEM_HOME_KEY.toUpperCase().equals(extra.toUpperCase())) {
                    if (UiUtils.isMainThread() && PreferenceHelper.getBoolean((String)"is_show_home_toast", (boolean)true)) {
                        Toast toast = Toast.makeText((Context)GlobalContext.getContext(), (CharSequence)"", (int)1);
                        LayoutInflater inflate = (LayoutInflater)GlobalContext.getContext().getSystemService("layout_inflater");
                        assert (inflate != null);
                        View v = inflate.inflate(R.layout.common_toast_layout, null);
                        TextView tv = (TextView)v.findViewById(R.id.message);
                        tv.setText((CharSequence)context.getResources().getString(R.string.poc_run_in_background));
                        toast.setView(v);
                        toast.show();
                    }
                    String account = PreferenceHelper.getString((String)"login_account", (String)"");
                    BaseActivity.isSelfActivity = false;
                    if (!StringUtils.isEmpty((String)account)) {
                        // empty if block
                    }
                    MessageProxy.sendNotificationStaus(true);
                    EventBus.getDefault().post((Object)new HomeOrRecentEvent());
                }
                if (!"recentapps".toUpperCase().equals(extra.toUpperCase())) break;
                boolean stop = RingPlayer.getInstance(context).isStop();
                String TAG = "HomeKeyReceiver";
                LogUtils.ILog((String)TAG, (String)("stop: " + stop));
                if (!stop) {
                    EventBus.getDefault().post((Object)new HomeOrRecentEvent());
                }
                MessageProxy.sendNotificationStaus(true);
                break;
            }
            case "com.xdja.poc.login": {
                AMnager.startLogin(context);
            }
        }
    }

    public static void registerHomeReceiver() {
        if (isRegister) {
            return;
        }
        isRegister = true;
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.CLOSE_SYSTEM_DIALOGS");
        filter.addAction("com.xdja.poc.login");
        GlobalContext.getContext().registerReceiver((BroadcastReceiver)homeKeyReceiver, filter);
    }

    public static void unRegisterHomeReceiver() {
        try {
            if (homeKeyReceiver != null && isRegister) {
                GlobalContext.getContext().unregisterReceiver((BroadcastReceiver)homeKeyReceiver);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

