/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.graphics.Matrix;
import android.os.Handler;
import javax.annotation.Nullable;
import org.webrtc.RefCountDelegate;
import org.webrtc.TextureBufferImpl$$Lambda$0;
import org.webrtc.TextureBufferImpl$$Lambda$1;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;
import org.webrtc.YuvConverter;

public class TextureBufferImpl
implements VideoFrame.TextureBuffer {
    private final int width;
    private final int height;
    private final VideoFrame.TextureBuffer.Type type;
    private final int id;
    private final Matrix transformMatrix;
    private final Handler toI420Handler;
    private final YuvConverter yuvConverter;
    private final RefCountDelegate refCountDelegate;

    public TextureBufferImpl(int width, int height, VideoFrame.TextureBuffer.Type type, int id, Matrix transformMatrix, Handler toI420Handler, YuvConverter yuvConverter, @Nullable Runnable releaseCallback) {
        this.width = width;
        this.height = height;
        this.type = type;
        this.id = id;
        this.transformMatrix = transformMatrix;
        this.toI420Handler = toI420Handler;
        this.yuvConverter = yuvConverter;
        this.refCountDelegate = new RefCountDelegate(releaseCallback);
    }

    @Override
    public VideoFrame.TextureBuffer.Type getType() {
        return this.type;
    }

    @Override
    public int getTextureId() {
        return this.id;
    }

    @Override
    public Matrix getTransformMatrix() {
        return this.transformMatrix;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        return (VideoFrame.I420Buffer)ThreadUtils.invokeAtFrontUninterruptibly(this.toI420Handler, new TextureBufferImpl$$Lambda$0(this));
    }

    @Override
    public void retain() {
        this.refCountDelegate.retain();
    }

    @Override
    public void release() {
        this.refCountDelegate.release();
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        Matrix newMatrix = new Matrix(this.transformMatrix);
        newMatrix.preTranslate((float)cropX / (float)this.width, (float)cropY / (float)this.height);
        newMatrix.preScale((float)cropWidth / (float)this.width, (float)cropHeight / (float)this.height);
        this.retain();
        return new TextureBufferImpl(scaleWidth, scaleHeight, this.type, this.id, newMatrix, this.toI420Handler, this.yuvConverter, new TextureBufferImpl$$Lambda$1(this));
    }

    final /* synthetic */ VideoFrame.I420Buffer lambda$toI420$0$TextureBufferImpl() throws Exception {
        return this.yuvConverter.convert(this);
    }
}

