/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.webrtc.CalledByNative;
import org.webrtc.JNINamespace;
import org.webrtc.JavaI420Buffer;
import org.webrtc.RendererCommon;
import org.webrtc.TextureBufferImpl;
import org.webrtc.VideoFrame;
import org.webrtc.VideoRenderer$I420Frame$$Lambda$0;
import org.webrtc.VideoRenderer$I420Frame$$Lambda$1;

@JNINamespace(value="webrtc::jni")
public class VideoRenderer {
    long nativeVideoRenderer;

    public static void renderFrameDone(I420Frame frame) {
        frame.yuvPlanes = null;
        frame.textureId = 0;
        if (frame.nativeFramePointer != 0L) {
            VideoRenderer.nativeReleaseFrame(frame.nativeFramePointer);
            frame.nativeFramePointer = 0L;
        }
    }

    public VideoRenderer(Callbacks callbacks) {
        this.nativeVideoRenderer = VideoRenderer.nativeCreateVideoRenderer(callbacks);
    }

    public void dispose() {
        if (this.nativeVideoRenderer == 0L) {
            return;
        }
        VideoRenderer.nativeFreeWrappedVideoRenderer(this.nativeVideoRenderer);
        this.nativeVideoRenderer = 0L;
    }

    private static native long nativeCreateVideoRenderer(Callbacks var0);

    private static native void nativeFreeWrappedVideoRenderer(long var0);

    private static native void nativeReleaseFrame(long var0);

    public static interface Callbacks {
        @CalledByNative(value="Callbacks")
        public void renderFrame(I420Frame var1);
    }

    public static class I420Frame {
        public final int width;
        public final int height;
        @Nullable
        public final int[] yuvStrides;
        @Nullable
        public ByteBuffer[] yuvPlanes;
        public final boolean yuvFrame;
        @Nullable
        public final float[] samplingMatrix;
        public int textureId;
        private long nativeFramePointer;
        public int rotationDegree;
        @Nullable
        private final VideoFrame.Buffer backingBuffer;

        public I420Frame(int width, int height, int rotationDegree, int[] yuvStrides, ByteBuffer[] yuvPlanes, long nativeFramePointer) {
            this.width = width;
            this.height = height;
            this.yuvStrides = yuvStrides;
            this.yuvPlanes = yuvPlanes;
            this.yuvFrame = true;
            this.rotationDegree = rotationDegree;
            this.nativeFramePointer = nativeFramePointer;
            this.backingBuffer = null;
            if (rotationDegree % 90 != 0) {
                throw new IllegalArgumentException("Rotation degree not multiple of 90: " + rotationDegree);
            }
            this.samplingMatrix = RendererCommon.verticalFlipMatrix();
        }

        public I420Frame(int width, int height, int rotationDegree, int textureId, float[] samplingMatrix, long nativeFramePointer) {
            this.width = width;
            this.height = height;
            this.yuvStrides = null;
            this.yuvPlanes = null;
            this.samplingMatrix = samplingMatrix;
            this.textureId = textureId;
            this.yuvFrame = false;
            this.rotationDegree = rotationDegree;
            this.nativeFramePointer = nativeFramePointer;
            this.backingBuffer = null;
            if (rotationDegree % 90 != 0) {
                throw new IllegalArgumentException("Rotation degree not multiple of 90: " + rotationDegree);
            }
        }

        @CalledByNative(value="I420Frame")
        public I420Frame(int rotationDegree, VideoFrame.Buffer buffer, long nativeFramePointer) {
            this.width = buffer.getWidth();
            this.height = buffer.getHeight();
            this.rotationDegree = rotationDegree;
            if (rotationDegree % 90 != 0) {
                throw new IllegalArgumentException("Rotation degree not multiple of 90: " + rotationDegree);
            }
            if (buffer instanceof VideoFrame.TextureBuffer && ((VideoFrame.TextureBuffer)buffer).getType() == VideoFrame.TextureBuffer.Type.OES) {
                VideoFrame.TextureBuffer textureBuffer = (VideoFrame.TextureBuffer)buffer;
                this.yuvFrame = false;
                this.textureId = textureBuffer.getTextureId();
                this.samplingMatrix = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(textureBuffer.getTransformMatrix());
                this.yuvStrides = null;
                this.yuvPlanes = null;
            } else if (buffer instanceof VideoFrame.I420Buffer) {
                VideoFrame.I420Buffer i420Buffer = (VideoFrame.I420Buffer)buffer;
                this.yuvFrame = true;
                this.yuvStrides = new int[]{i420Buffer.getStrideY(), i420Buffer.getStrideU(), i420Buffer.getStrideV()};
                this.yuvPlanes = new ByteBuffer[]{i420Buffer.getDataY(), i420Buffer.getDataU(), i420Buffer.getDataV()};
                this.samplingMatrix = RendererCommon.verticalFlipMatrix();
                this.textureId = 0;
            } else {
                this.yuvFrame = false;
                this.textureId = 0;
                this.samplingMatrix = null;
                this.yuvStrides = null;
                this.yuvPlanes = null;
            }
            this.nativeFramePointer = nativeFramePointer;
            this.backingBuffer = buffer;
        }

        public int rotatedWidth() {
            return this.rotationDegree % 180 == 0 ? this.width : this.height;
        }

        public int rotatedHeight() {
            return this.rotationDegree % 180 == 0 ? this.height : this.width;
        }

        public String toString() {
            String type = this.yuvFrame ? "Y: " + this.yuvStrides[0] + ", U: " + this.yuvStrides[1] + ", V: " + this.yuvStrides[2] : "Texture: " + this.textureId;
            return this.width + "x" + this.height + ", " + type;
        }

        VideoFrame toVideoFrame() {
            VideoFrame.Buffer buffer;
            if (this.backingBuffer != null) {
                this.backingBuffer.retain();
                VideoRenderer.renderFrameDone(this);
                buffer = this.backingBuffer;
            } else {
                buffer = this.yuvFrame ? JavaI420Buffer.wrap(this.width, this.height, this.yuvPlanes[0], this.yuvStrides[0], this.yuvPlanes[1], this.yuvStrides[1], this.yuvPlanes[2], this.yuvStrides[2], new VideoRenderer$I420Frame$$Lambda$0(this)) : new TextureBufferImpl(this.width, this.height, VideoFrame.TextureBuffer.Type.OES, this.textureId, RendererCommon.convertMatrixToAndroidGraphicsMatrix(this.samplingMatrix), null, null, new VideoRenderer$I420Frame$$Lambda$1(this));
            }
            return new VideoFrame(buffer, this.rotationDegree, 0L);
        }

        @CalledByNative(value="I420Frame")
        static I420Frame createI420Frame(int width, int height, int rotationDegree, int y_stride, ByteBuffer y_buffer, int u_stride, ByteBuffer u_buffer, int v_stride, ByteBuffer v_buffer, long nativeFramePointer) {
            return new I420Frame(width, height, rotationDegree, new int[]{y_stride, u_stride, v_stride}, new ByteBuffer[]{y_buffer, u_buffer, v_buffer}, nativeFramePointer);
        }

        final /* synthetic */ void lambda$toVideoFrame$1$VideoRenderer$I420Frame() {
            VideoRenderer.renderFrameDone(this);
        }

        final /* synthetic */ void lambda$toVideoFrame$0$VideoRenderer$I420Frame() {
            VideoRenderer.renderFrameDone(this);
        }
    }
}

