/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business;

import android.content.Context;
import android.content.Intent;
import com.xdja.poc.common.event.CancelNotification;
import com.xdja.poc.common.utils.GlobalContext;
import com.xdja.poc.sdk.POCClient;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.business.bean.POCCallMessage;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import com.xdja.poc.sdk.event.GroupEvent;
import com.xdja.poc.sdk.event.GroupListEvent;
import com.xdja.poc.sdk.event.UpdateNotification;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.greenrobot.eventbus.EventBus;

public class MessageProxy {
    public static final String USER_ID = "userId";
    public static final String ROOM_ID = "roomId";
    public static final String POC_GROUP = "poc_group";
    public static final String GROUP_EVENT_TYPE = "group_event_type";
    public static final String SWITCH_MUTE_STATUS = "switch_mute_status";

    public static void sendGetPocAllRoom(ArrayList<DBGroupEntity> mList) {
        EventBus.getDefault().post((Object)new GroupListEvent(mList));
    }

    public static void sendSelfLeaveEvent(Context context, String roomId, List<String> memberList) {
        Intent intent = new Intent("com.xdja.poc.service");
        intent.setPackage(context.getPackageName());
        intent.putExtra(ROOM_ID, roomId);
        String memberInfos = POCClient.getInstance().generateListString(memberList);
        intent.putExtra("flag", 1011);
        intent.putExtra("member_info", memberInfos);
        intent.putExtra(GROUP_EVENT_TYPE, 0);
        context.sendBroadcast(intent);
    }

    public static void sendUserChanged(Context context, String roomId, List<String> memberList) {
        Intent intent = new Intent("com.xdja.poc.service");
        intent.setPackage(context.getPackageName());
        intent.putExtra(ROOM_ID, roomId);
        String memberInfos = POCClient.getInstance().generateListString(memberList);
        intent.putExtra("flag", 1011);
        intent.putExtra("member_info", memberInfos);
        context.sendBroadcast(intent);
    }

    public static void sendUserChanged(Context context, String roomId, List<String> memberList, int eventType) {
        Intent intent = new Intent("com.xdja.poc.service");
        intent.setPackage(context.getPackageName());
        intent.putExtra(ROOM_ID, roomId);
        String memberInfos = POCClient.getInstance().generateListString(memberList);
        intent.putExtra("flag", 1010);
        intent.putExtra("member_info", memberInfos);
        int status = 0;
        int behavior = 0;
        switch (eventType) {
            case 9005: {
                status = 1;
                behavior = 0;
                break;
            }
            case 9003: {
                status = 1;
                behavior = 1;
                break;
            }
            case 9014: {
                status = 2;
                behavior = 0;
                break;
            }
            case 9015: {
                status = 1;
                behavior = 0;
                break;
            }
            case 9100: {
                status = 0;
                behavior = 9000;
                break;
            }
            case 9007: {
                status = 0;
                behavior = 0;
                break;
            }
            case 9000: {
                status = 0;
                behavior = 9000;
                break;
            }
            case 9102: {
                status = 0;
                behavior = 9000;
            }
        }
        intent.putExtra(GROUP_EVENT_TYPE, status);
        intent.putExtra("room_user_behavior", behavior);
        context.sendBroadcast(intent);
    }

    public static void sendUserIncomeOrLeave(Context context, String roomId, String userId, int flag) {
        Intent intent = new Intent("com.xdja.poc.service");
        intent.setPackage(context.getPackageName());
        intent.putExtra(ROOM_ID, roomId);
        intent.putExtra("member_info", userId);
        int behavior = 0;
        switch (flag) {
            case 9005: {
                behavior = 0;
                break;
            }
            case 9003: {
                behavior = 1;
            }
        }
        intent.putExtra("flag", 1015);
        intent.putExtra("room_user_behavior", behavior);
        context.sendBroadcast(intent);
    }

    public static void sendMeIncomingRoom(Context context, List<String> memberList, String roomId) {
        Intent intent = new Intent("com.xdja.poc.service");
        intent.setPackage(context.getPackageName());
        String memberInfos = POCClient.getInstance().generateListString(memberList);
        intent.putExtra("flag", 1016);
        intent.putExtra("member_info", memberInfos);
        intent.putExtra(ROOM_ID, roomId);
        context.sendBroadcast(intent);
    }

    public static void reBindService(Context context) {
        Intent intent = new Intent("com.xdja.poc.service");
        intent.setPackage(context.getPackageName());
        intent.putExtra("flag", 1013);
        context.sendBroadcast(intent);
    }

    public static void sendNotificationStaus(boolean isShow) {
        CancelNotification cancelNotification = new CancelNotification((Object)isShow);
        EventBus.getDefault().post((Object)cancelNotification);
    }

    public static void sendSwitchMuteStatus(boolean enable) {
        Intent intent = new Intent();
        intent.setAction("action_poc_switch_mute_status");
        intent.putExtra(SWITCH_MUTE_STATUS, enable);
        intent.setPackage(GlobalContext.getContext().getPackageName());
        GlobalContext.getContext().sendBroadcast(intent);
    }

    public static void updateNotificationCallMessage(Context context, POCCallMessage userName, boolean isRing) {
        EventBus.getDefault().post((Object)new UpdateNotification(isRing, userName));
    }

    public static void notifyUserLogOut() {
        EventBus.getDefault().post((Object)new UpdateNotification(false));
    }

    public static GroupEvent generateGroupEvent(int code, int position, String roomId, int type, String memberIds, Map<String, POCMemberInfo> userInfos) {
        GroupEvent event = new GroupEvent();
        event.setCode(code);
        event.setPosition(position);
        event.setRoomId(roomId);
        event.setEventTyep(type);
        event.setUserInfo(userInfos);
        event.setMembers(memberIds);
        return event;
    }
}

