/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business.plugincallback;

import android.support.annotation.Nullable;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.business.POCRoom;
import com.xdja.poc.sdk.business.plugincallback.JanusListenerAttachCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IJanusPluginCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IPluginHandleSendMessageCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IPluginHandleWebRTCCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusMediaConstraints;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusPluginHandleWithWebrtc;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusServer;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusSupportedPluginPackages;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.PluginHandleSendMessageCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.PluginHandleWebRTCCallbacks;
import com.xdja.poc.sdk.config.JaunsApi;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.MediaStream;
import org.webrtc.VideoSink;

public class JanusCreateRoomPluginCallbacks
implements IJanusPluginCallbacks {
    private static final String TAG = "JanusCreateRoom";
    private JanusPluginHandleWithWebrtc handle = null;
    private volatile boolean bWaitTakenTBCPResult = false;
    private volatile String currTransaction = null;
    private JanusListenerAttachCallbacks listenerAttachCallbacks;
    private BigInteger newPunishId;
    private BigInteger privateId;
    private long roomId = -1L;
    private String userName;
    private POCRoom pocRoom;
    ArrayList<String> memberList = new ArrayList();
    private boolean needPlayer = false;
    private boolean muteState = false;

    public JanusCreateRoomPluginCallbacks(long roomId, String userName, POCRoom pocRoom) {
        this.roomId = roomId;
        this.userName = userName;
        this.pocRoom = pocRoom;
    }

    public void editroom(long roomId, String secret, String newDescription, String newSecret, String newPin, @Nullable Boolean newIsPrivated, @Nullable Boolean newRequirePrivated, @Nullable Integer newBitrate, @Nullable Integer newFirFreq, @Nullable Integer newPublishers, @Nullable Boolean permanent) {
        if (this.handle != null) {
            JSONObject jsonObject = JaunsApi.editRoom(roomId, secret, newDescription, newSecret, newPin, newIsPrivated, newRequirePrivated, newBitrate, newFirFreq, newPublishers, permanent);
            this.handle.sendMessage(new PluginHandleSendMessageCallbacks(jsonObject));
        }
    }

    public void kickPerson(final long roomID, int personId, String secret) {
        if (this.handle != null) {
            final JSONObject jsonObject = JaunsApi.kickPerson(roomID, personId, secret);
            this.handle.sendMessage(new IPluginHandleSendMessageCallbacks(){

                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog((String)"Zhangs", (String)("kickPerson 837 : " + obj.toString()));
                    if (obj.has("error_code")) {
                        JanusCreateRoomPluginCallbacks.this.pocRoom.onRoomStatus(roomID, 9024, obj.optString("error"));
                    } else {
                        JanusCreateRoomPluginCallbacks.this.pocRoom.onRoomStatus(roomID, 9023, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {
                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {
                }
            });
        }
    }

    public void publish(final long roomID, boolean audio, boolean video, boolean data, String audioCode, String videoCode, int bitrate, boolean record, String fileName, String display) {
        if (this.handle != null) {
            final JSONObject jsonObject = JaunsApi.publish(audio, video, data, audioCode, videoCode, bitrate, record, fileName, display);
            this.handle.sendMessage(new IPluginHandleSendMessageCallbacks(){

                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog((String)"Zhangs", (String)("publish 911 : " + obj));
                    if (obj.has("error_code")) {
                        JanusCreateRoomPluginCallbacks.this.pocRoom.onRoomStatus(roomID, 9027, obj.optString("error"));
                    } else {
                        JanusCreateRoomPluginCallbacks.this.pocRoom.onRoomStatus(roomID, 9028, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {
                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {
                }
            });
        }
    }

    public JanusListenerAttachCallbacks getHandler() {
        return this.listenerAttachCallbacks;
    }

    public void startPlayer(boolean value) {
        if (this.handle != null) {
            this.handle.startPlayer(value);
        }
    }

    public void unpublish(final long roomID) {
        if (this.handle != null) {
            final JSONObject jsonObject = JaunsApi.unpublish();
            this.handle.sendMessage(new IPluginHandleSendMessageCallbacks(){

                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog((String)"Zhangs", (String)("unpublish 937 : " + obj));
                    if (obj.has("error_code")) {
                        JanusCreateRoomPluginCallbacks.this.pocRoom.onRoomStatus(roomID, 9030, obj.optString("error"));
                    } else {
                        JanusCreateRoomPluginCallbacks.this.pocRoom.onRoomStatus(roomID, 9029, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {
                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {
                }
            });
        }
    }

    public void configure(final long roomId, boolean audio, boolean video, boolean data, int bitrate, boolean record, String fileName, String display) {
        if (this.handle != null) {
            final JSONObject jsonObject = JaunsApi.configure(audio, video, data, bitrate, record, fileName, display);
            this.handle.sendMessage(new IPluginHandleSendMessageCallbacks(){

                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog((String)"Zhangs", (String)("configure 963 : " + obj));
                    if (obj.has("error_code")) {
                        JanusCreateRoomPluginCallbacks.this.pocRoom.onRoomStatus(roomId, 9032, obj.optString("error"));
                    } else {
                        JanusCreateRoomPluginCallbacks.this.pocRoom.onRoomStatus(roomId, 9031, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {
                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {
                }
            });
        }
    }

    public void subscriberJoin(final long roomId, BigInteger feedId, String pin, BigInteger privateId, boolean closePc, boolean audio, boolean video, boolean data, boolean offerAudio, boolean offerVideo, boolean offerData) {
        if (this.handle != null) {
            final JSONObject jsonObject = JaunsApi.subscriberJoin(roomId, feedId, pin, privateId, closePc, audio, video, data, offerAudio, offerVideo, offerData);
            this.handle.sendMessage(new IPluginHandleSendMessageCallbacks(){

                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog((String)"Zhangs", (String)("subscriberJoin 990 : " + obj));
                    if (obj.has("error_code")) {
                        JanusCreateRoomPluginCallbacks.this.pocRoom.onRoomStatus(roomId, 9047, obj.optString("error"));
                    } else {
                        JanusCreateRoomPluginCallbacks.this.pocRoom.onRoomStatus(roomId, 9048, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {
                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {
                    JanusCreateRoomPluginCallbacks.this.pocRoom.onRoomStatus(roomId, 9004, error);
                }
            });
        }
    }

    public void mute(boolean enable) {
        this.muteState = enable;
        if (this.handle != null) {
            this.handle.mute(enable);
        }
    }

    public boolean getMuteState() {
        if (this.listenerAttachCallbacks != null) {
            return this.listenerAttachCallbacks.getMuteState();
        }
        return true;
    }

    public void startMedia(final long roomId) {
        if (this.handle != null) {
            final JSONObject jsonObject = JaunsApi.startMedia(roomId);
            this.handle.sendMessage(new IPluginHandleSendMessageCallbacks(){

                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog((String)"Zhangs", (String)("startMedia 244 : " + obj));
                    if (obj.has("error_code")) {
                        JanusCreateRoomPluginCallbacks.this.pocRoom.onRoomStatus(roomId, 9033, obj.optString("error"));
                    } else {
                        JanusCreateRoomPluginCallbacks.this.pocRoom.onRoomStatus(roomId, 9034, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {
                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {
                }
            });
        }
    }

    public void pauseMedia(final long roomId) {
        if (this.handle != null) {
            final JSONObject jsonObject = JaunsApi.pauseMedia(roomId);
            this.handle.sendMessage(new IPluginHandleSendMessageCallbacks(){

                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog((String)"Zhangs", (String)("pauseMedia 1042 : " + obj));
                    if (obj.has("error_code")) {
                        JanusCreateRoomPluginCallbacks.this.pocRoom.onRoomStatus(roomId, 9036, obj.optString("error"));
                    } else {
                        JanusCreateRoomPluginCallbacks.this.pocRoom.onRoomStatus(roomId, 9035, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {
                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {
                }
            });
        }
    }

    public void switchSubscriber(final long roomId, int feed, boolean audio, boolean video, boolean data) {
        if (this.handle != null) {
            final JSONObject jsonObject = JaunsApi.switchSubscriber(feed, audio, video, data);
            this.handle.sendMessage(new IPluginHandleSendMessageCallbacks(){

                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog((String)"Zhangs", (String)("switchSubscriber 1068 : " + obj));
                    if (obj.has("error_code")) {
                        JanusCreateRoomPluginCallbacks.this.pocRoom.onRoomStatus(roomId, 9037, obj.optString("error"));
                    } else {
                        JanusCreateRoomPluginCallbacks.this.pocRoom.onRoomStatus(roomId, 9038, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {
                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {
                    JanusCreateRoomPluginCallbacks.this.pocRoom.onRoomStatus(roomId, 9002, error);
                }
            });
        }
    }

    public void joinRoom(long roomId, @Nullable Integer userId, String userName, String pin, String token) {
        if (this.handle != null) {
            JSONObject join = JaunsApi.join(roomId, userId, userName, pin, token);
            this.handle.sendMessage(new PluginHandleSendMessageCallbacks(join));
        } else {
            LogUtils.DLog((String)"zlq", (String)"joinRoom handle is null");
        }
    }

    public void publishOwnFeed(final String audioCodec) {
        if (this.handle != null) {
            this.handle.createOffer(new IPluginHandleWebRTCCallbacks(){

                @Override
                public void onSuccess(JSONObject obj) {
                    try {
                        final JSONObject msg = new JSONObject();
                        JSONObject body = new JSONObject();
                        body.put("request", (Object)"configure");
                        body.put("audio", true);
                        body.put("audiocodec", (Object)audioCodec);
                        body.put("video", false);
                        body.put("data", true);
                        msg.put("message", (Object)body);
                        msg.put("jsep", (Object)obj);
                        JanusCreateRoomPluginCallbacks.this.handle.sendMessage(new IPluginHandleSendMessageCallbacks(){

                            @Override
                            public void onSuccessSynchronous(JSONObject obj) {
                            }

                            @Override
                            public void onSuccesAsynchronous() {
                            }

                            @Override
                            public JSONObject getMessage() {
                                return msg;
                            }

                            @Override
                            public void onCallbackError(String error) {
                                JanusCreateRoomPluginCallbacks.this.pocRoom.onRoomStatus(JanusCreateRoomPluginCallbacks.this.roomId, 9002, error);
                            }
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                @Override
                public JSONObject getJsep() {
                    return null;
                }

                @Override
                public JanusMediaConstraints getMedia() {
                    JanusMediaConstraints cons = new JanusMediaConstraints();
                    cons.setRecvAudio(true);
                    cons.setRecvVideo(false);
                    cons.setSendAudio(true);
                    cons.setAudioCodec(audioCodec);
                    return cons;
                }

                @Override
                public Boolean getTrickle() {
                    return true;
                }

                @Override
                public VideoSink getRemoteSink() {
                    return null;
                }

                @Override
                public void onCallbackError(String error) {
                    LogUtils.ELog((String)JanusCreateRoomPluginCallbacks.TAG, (String)("error: " + error));
                    if (JanusCreateRoomPluginCallbacks.this.handle != null) {
                        JanusCreateRoomPluginCallbacks.this.handle.hangUp();
                    }
                }
            });
        }
    }

    public List<String> getMemberList() {
        if (this.memberList != null) {
            LogUtils.ILog((String)TAG, (String)("onLineMemberList size: " + this.memberList.size() + "  onLineMemberList: " + this.memberList.toString()));
        }
        return this.memberList;
    }

    public synchronized void takenTBCP() {
        if (!this.pocRoom.isJoined() && !this.pocRoom.isCreated()) {
            this.pocRoom.onRoomStatus(this.roomId, 9005, "");
            return;
        }
        this.bWaitTakenTBCPResult = true;
        JanusServer.RandomString stringGenerator = new JanusServer.RandomString();
        this.currTransaction = stringGenerator.randomString(12);
        JSONObject jsonObject = JaunsApi.takenTBCP(this.roomId, this.currTransaction);
        if (this.handle != null) {
            this.handle.sendMsgOverDataChannel(jsonObject.toString());
        }
    }

    public synchronized void releaseTBCP() {
        if (!this.pocRoom.isJoined() && !this.pocRoom.isCreated()) {
            this.pocRoom.onRoomStatus(this.roomId, 9005, "");
            return;
        }
        this.bWaitTakenTBCPResult = true;
        JanusServer.RandomString stringGenerator = new JanusServer.RandomString();
        this.currTransaction = stringGenerator.randomString(12);
        JSONObject jsonObject = JaunsApi.releaseTBCP(this.roomId, this.currTransaction);
        if (this.handle != null) {
            this.handle.sendMsgOverDataChannel(jsonObject.toString());
        }
        if (this.handle != null) {
            this.handle.releaseTBCP();
        }
    }

    public void sendMsgToRoom(String msg) {
        if (this.handle != null) {
            this.handle.sendMsgOverDataChannel(msg);
        }
    }

    private void unPublishRoom() {
        if (this.handle != null) {
            JSONObject unpublish = JaunsApi.unpublish();
            this.handle.sendMessage(new PluginHandleSendMessageCallbacks(unpublish));
        }
    }

    public void hangup() {
        if (this.handle != null) {
            this.handle.hangUp();
        }
        if (this.listenerAttachCallbacks != null && this.listenerAttachCallbacks.getHandler() != null) {
            this.listenerAttachCallbacks.getHandler().hangUp();
        }
    }

    public void destoryRoom(String secret, @Nullable Boolean permanent) {
        this.unPublishRoom();
        if (this.listenerAttachCallbacks != null) {
            this.listenerAttachCallbacks.leaveRoom();
        }
        if (this.handle != null) {
            final JSONObject jsonObject = JaunsApi.destroyRoom(this.roomId, secret, permanent);
            this.handle.sendMessage(new IPluginHandleSendMessageCallbacks(){

                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    if (obj != null && obj.has("error_code")) {
                        try {
                            JanusCreateRoomPluginCallbacks.this.pocRoom.onRoomStatus(JanusCreateRoomPluginCallbacks.this.roomId, 9008, obj.getString("error"));
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }

                @Override
                public void onSuccesAsynchronous() {
                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {
                    LogUtils.ELog((String)JanusCreateRoomPluginCallbacks.TAG, (String)("error: " + error));
                    JanusCreateRoomPluginCallbacks.this.pocRoom.onRoomStatus(JanusCreateRoomPluginCallbacks.this.roomId, 9008, error);
                }
            });
            this.handle.hangUp();
        }
    }

    public synchronized void leaveRoom() {
        if (!this.pocRoom.isJoined() && !this.pocRoom.isCreated()) {
            this.pocRoom.onRoomStatus(this.roomId, 9005, "");
            return;
        }
        this.unPublishRoom();
        if (this.listenerAttachCallbacks != null) {
            this.listenerAttachCallbacks.leaveRoom();
        }
        if (this.handle != null) {
            this.handle.sendMessage(new IPluginHandleSendMessageCallbacks(){

                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    JanusCreateRoomPluginCallbacks.this.pocRoom.onRoomStatus(JanusCreateRoomPluginCallbacks.this.roomId, 9005, "");
                    if (JanusCreateRoomPluginCallbacks.this.memberList != null) {
                        JanusCreateRoomPluginCallbacks.this.memberList.clear();
                    }
                    JanusCreateRoomPluginCallbacks.this.pocRoom.removeCallbackFromJanusServer();
                }

                @Override
                public void onSuccesAsynchronous() {
                    JanusCreateRoomPluginCallbacks.this.pocRoom.onRoomStatus(JanusCreateRoomPluginCallbacks.this.roomId, 9005, "");
                    if (JanusCreateRoomPluginCallbacks.this.memberList != null) {
                        JanusCreateRoomPluginCallbacks.this.memberList.clear();
                    }
                    JanusCreateRoomPluginCallbacks.this.pocRoom.removeCallbackFromJanusServer();
                }

                @Override
                public JSONObject getMessage() {
                    JSONObject msg = JaunsApi.leaveRoom();
                    return msg;
                }

                @Override
                public void onCallbackError(String error) {
                    LogUtils.ELog((String)JanusCreateRoomPluginCallbacks.TAG, (String)("error: " + error));
                }
            });
            if (this.handle != null) {
                this.handle.hangUp();
            }
        }
    }

    public void createRoom(final long roomId, String secret, final String pin, String userId, final String userName, String description, @Nullable Boolean permanent, @Nullable Boolean isPrivate) {
        if (this.handle != null) {
            final JSONObject room = JaunsApi.createRoom(roomId, secret, pin, userName, description, permanent, isPrivate);
            this.handle.sendMessage(new IPluginHandleSendMessageCallbacks(){

                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    JanusCreateRoomPluginCallbacks.this.pocRoom.setCreating(false);
                    if (obj != null) {
                        LogUtils.DLog((String)JanusCreateRoomPluginCallbacks.TAG, (String)obj.toString());
                        try {
                            if (obj.has("room") && obj.getLong("room") == roomId) {
                                JanusCreateRoomPluginCallbacks.this.pocRoom.onRoomStatus(roomId, 9001, null);
                                JanusCreateRoomPluginCallbacks.this.pocRoom.setCreated(true);
                                JanusCreateRoomPluginCallbacks.this.joinRoom(roomId, 0, userName, pin, null);
                            } else {
                                LogUtils.DLog((String)JanusCreateRoomPluginCallbacks.TAG, (String)("err:" + obj.get("error")));
                                int error_code = obj.getInt("error_code");
                                if (error_code == 427) {
                                    String error = obj.getString("error");
                                    JanusCreateRoomPluginCallbacks.this.pocRoom.onRoomStatus(roomId, 9051, error);
                                    JanusCreateRoomPluginCallbacks.this.pocRoom.setCreated(true);
                                    JanusCreateRoomPluginCallbacks.this.joinRoom(roomId, 0, userName, pin, null);
                                } else {
                                    String error = obj.getString("error");
                                    JanusCreateRoomPluginCallbacks.this.pocRoom.onRoomStatus(roomId, 9050, error);
                                }
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }

                @Override
                public void onSuccesAsynchronous() {
                }

                @Override
                public JSONObject getMessage() {
                    return room;
                }

                @Override
                public void onCallbackError(String error) {
                    LogUtils.ELog((String)JanusCreateRoomPluginCallbacks.TAG, (String)("error: " + error));
                    JanusCreateRoomPluginCallbacks.this.pocRoom.setCreated(false);
                    JanusCreateRoomPluginCallbacks.this.pocRoom.setCreating(false);
                    JanusCreateRoomPluginCallbacks.this.pocRoom.setJoined(false);
                    JanusCreateRoomPluginCallbacks.this.pocRoom.onRoomStatus(roomId, 9002, error);
                }
            });
        }
    }

    public void newRemoteFeed(BigInteger id2, String audioCodec) {
        LogUtils.DLog((String)TAG, (String)("newRemoteFeed needPlayer: " + this.needPlayer));
        this.listenerAttachCallbacks = new JanusListenerAttachCallbacks(this.roomId, this.privateId, id2, null, this.pocRoom, this.needPlayer);
        this.listenerAttachCallbacks.setAudioCode(audioCodec);
        this.listenerAttachCallbacks.mute(this.muteState);
        this.pocRoom.attach(this.listenerAttachCallbacks);
    }

    @Override
    @Deprecated
    public void success(JanusPluginHandleWithWebrtc handle1) {
        this.handle = handle1;
        this.pocRoom.attachSuccess();
    }

    @Override
    public void onMessage(JSONObject msg, JSONObject jsepLocal) {
        try {
            String event = msg.getString("videoroom");
            LogUtils.DLog((String)TAG, (String)("onMessage:" + event));
            if (event.equals("joined")) {
                JSONObject pub;
                int i;
                JSONArray pubs;
                this.privateId = msg.has("private_id") ? new BigInteger(msg.getString("private_id")) : new BigInteger(msg.getString("id"));
                String audioCodec = "opus";
                if (msg.has("publishers")) {
                    pubs = msg.getJSONArray("publishers");
                    for (i = 0; i < pubs.length(); ++i) {
                        pub = pubs.getJSONObject(i);
                        this.newPunishId = new BigInteger(pub.getString("id"));
                        if (!pub.has("audio_codec")) continue;
                        audioCodec = pub.getString("audio_codec");
                    }
                }
                this.publishOwnFeed(audioCodec);
                pubs = null;
                if (msg.has("subscribeIdList")) {
                    pubs = msg.getJSONArray("subscribeIdList");
                    for (i = 0; i < pubs.length(); ++i) {
                        pub = pubs.getJSONObject(i);
                        String userid = pub.getString("display");
                        if (this.memberList.contains(userid)) continue;
                        this.memberList.add(userid);
                    }
                }
                LogUtils.DLog((String)TAG, (String)("send Constants.ROOM_JOIN_SUCCESS:" + this.roomId));
                this.pocRoom.onRoomStatus(this.roomId, 9003, pubs.toString());
                if (msg.has("current_publisher")) {
                    this.needPlayer = true;
                    this.pocRoom.onTBCP(9014, msg.optString("current_publisher"));
                }
            } else if (event.equals("destroyed")) {
                this.handle.detach();
                this.pocRoom.onRoomStatus(this.roomId, 9007, event);
                this.pocRoom.setDestroy(true);
            } else if (event.equals("event")) {
                if (msg.has("leaving")) {
                    String user = msg.getString("leaving");
                    if (user != null && !user.equals(this.userName)) {
                        if (user.equals(this.pocRoom.getCurrTBCPUser())) {
                            this.pocRoom.resetCurrTBCPUser();
                        }
                        this.memberList.remove(user);
                        this.pocRoom.onRoomStatus(this.roomId, 9016, msg.getString("leaving"));
                    }
                } else if (msg.has("publishers")) {
                    JSONArray pubs = msg.getJSONArray("publishers");
                    JSONObject pub = pubs.getJSONObject(0);
                    if (pub.has("display")) {
                        String userid = pub.getString("display");
                        if (!this.memberList.contains(userid)) {
                            this.memberList.add(userid);
                        }
                        this.pocRoom.onRoomStatus(this.roomId, 9017, userid);
                    }
                } else if (msg.has("unpublished")) {
                    String user = msg.getString("unpublished");
                    if (user != null && user.equals(this.userName)) {
                        this.memberList.remove(user);
                        this.pocRoom.onRoomStatus(this.roomId, 9005, user);
                    }
                } else if (msg.has("started")) {
                    // empty if block
                }
                if (jsepLocal != null) {
                    this.handle.handleRemoteJsep(new PluginHandleWebRTCCallbacks(null, jsepLocal, false));
                }
            } else {
                LogUtils.DLog((String)TAG, (String)("event:" + event));
            }
        }
        catch (Exception ex) {
            LogUtils.ELog((Throwable)ex);
        }
    }

    @Override
    public void onLocalStream(MediaStream stream) {
    }

    @Override
    public void onRemoteStream(MediaStream stream) {
    }

    @Override
    public void onDataOpen(Object data) {
        this.pocRoom.onRoomStatus(this.roomId, 9101, "");
    }

    @Override
    public void onData(Object data) {
        boolean ret = true;
        if (data instanceof JSONObject) {
            ret = false;
        }
        if (ret) {
            return;
        }
        this.ack();
        this.pocRoom.handleTBCP(this.bWaitTakenTBCPResult, (JSONObject)data, this.currTransaction, this.handle, null);
        if (this.bWaitTakenTBCPResult) {
            this.bWaitTakenTBCPResult = false;
            this.currTransaction = null;
        }
    }

    private void ack() {
        try {
            JSONObject obj = new JSONObject();
            obj.put("request", (Object)"tbcp");
            obj.put("type", (Object)"ack");
            obj.put("room", this.roomId);
            if (this.handle != null) {
                this.handle.sendMsgOverDataChannel(obj.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onCleanup() {
        if (this.handle != null) {
            this.handle.hangUp();
        }
    }

    @Override
    public JanusSupportedPluginPackages getPlugin() {
        return JanusSupportedPluginPackages.JANUS_POC_ROOM;
    }

    @Override
    public void onCallbackError(String error) {
        LogUtils.ELog((String)TAG, (String)("err:" + error));
        this.pocRoom.setCreated(false);
        this.pocRoom.setCreating(false);
        this.pocRoom.setJoined(false);
        if (this.handle != null) {
            this.handle.hangUp();
        }
        if (this.memberList != null) {
            this.memberList.clear();
        }
        if (error != null && error.contains("connection failed")) {
            this.pocRoom.onRoomStatus(this.roomId, 9100, error);
        } else {
            this.pocRoom.onRoomStatus(this.roomId, 9002, error);
        }
    }

    @Override
    public void onDetached() {
        if (this.handle != null) {
            this.handle.hangUp();
        }
        if (this.memberList != null) {
            this.memberList.clear();
        }
        this.handle = null;
        this.pocRoom.onRoomStatus(this.roomId, 8999, "");
    }
}

