/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business.webrtc.apprtc;

import android.os.Environment;
import com.xdja.poc.common.utils.LogUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import org.webrtc.audio.JavaAudioDeviceModule;
import org.webrtc.voiceengine.WebRtcAudioRecord;

public class RecordedAudioToFileController
implements JavaAudioDeviceModule.SamplesReadyCallback,
WebRtcAudioRecord.WebRtcAudioRecordSamplesReadyCallback {
    private static final String TAG = "RecordedAudioToFile";
    private static final long MAX_FILE_SIZE_IN_BYTES = 58348800L;
    private final Object lock = new Object();
    private final ExecutorService executor;
    private OutputStream rawAudioFileOutputStream = null;
    private boolean isRunning;
    private long fileSizeInBytes = 0L;

    public RecordedAudioToFileController(ExecutorService executor) {
        LogUtils.DLog((String)TAG, (String)"ctor");
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        LogUtils.DLog((String)TAG, (String)"start");
        if (!this.isExternalStorageWritable()) {
            LogUtils.ELog((String)TAG, (String)"Writing to external media is not possible");
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            this.isRunning = true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LogUtils.DLog((String)TAG, (String)"stop");
        Object object = this.lock;
        synchronized (object) {
            this.isRunning = false;
            if (this.rawAudioFileOutputStream != null) {
                try {
                    this.rawAudioFileOutputStream.close();
                }
                catch (IOException e) {
                    LogUtils.ELog((String)TAG, (String)("Failed to close file with saved input audio: " + e));
                }
                this.rawAudioFileOutputStream = null;
            }
            this.fileSizeInBytes = 0L;
        }
    }

    private boolean isExternalStorageWritable() {
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state);
    }

    private void openRawAudioOutputFile(int sampleRate, int channelCount) {
        String fileName = Environment.getExternalStorageDirectory().getPath() + File.separator + "recorded_audio_16bits_" + String.valueOf(sampleRate) + "Hz" + (channelCount == 1 ? "_mono" : "_stereo") + ".pcm";
        File outputFile = new File(fileName);
        try {
            this.rawAudioFileOutputStream = new FileOutputStream(outputFile);
        }
        catch (FileNotFoundException e) {
            LogUtils.ELog((String)TAG, (String)("Failed to open audio output file: " + e.getMessage()));
        }
        LogUtils.DLog((String)TAG, (String)("Opened file for recording: " + fileName));
    }

    public void onWebRtcAudioRecordSamplesReady(WebRtcAudioRecord.AudioSamples samples) {
        this.onWebRtcAudioRecordSamplesReady(new JavaAudioDeviceModule.AudioSamples(samples.getAudioFormat(), samples.getChannelCount(), samples.getSampleRate(), samples.getData()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWebRtcAudioRecordSamplesReady(final JavaAudioDeviceModule.AudioSamples samples) {
        if (samples.getAudioFormat() != 2) {
            LogUtils.ELog((String)TAG, (String)"Invalid audio format");
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.isRunning) {
                return;
            }
            if (this.rawAudioFileOutputStream == null) {
                this.openRawAudioOutputFile(samples.getSampleRate(), samples.getChannelCount());
                this.fileSizeInBytes = 0L;
            }
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RecordedAudioToFileController.this.rawAudioFileOutputStream != null) {
                    try {
                        if (RecordedAudioToFileController.this.fileSizeInBytes < 58348800L) {
                            RecordedAudioToFileController.this.rawAudioFileOutputStream.write(samples.getData());
                            RecordedAudioToFileController.this.fileSizeInBytes = RecordedAudioToFileController.this.fileSizeInBytes + (long)samples.getData().length;
                        }
                    }
                    catch (IOException e) {
                        LogUtils.ELog((String)RecordedAudioToFileController.TAG, (String)("Failed to write audio to file: " + e.getMessage()));
                    }
                }
            }
        });
    }
}

