/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.manager;

import android.app.KeyguardManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.business.bean.POCCallMessage;
import com.xdja.poc.sdk.config.GroupConfig;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import java.io.Serializable;

public class AMnager {
    public static String TAG = "AManager";
    private static String SCHEME = "xdja";
    public static String URI_STRING = SCHEME + "://";
    public static final String INTENT_KEY_CALL_WAITING_DATE = "intent_key_call_waiting_data";

    public static void startPOCConversionActivity(Context context, DBGroupEntity group, String channelName, int position, boolean isCallMember) {
        try {
            if (context == null) {
                LogUtils.ELog((String)TAG, (String)"startPOCChatActivity context can't null");
                return;
            }
            Uri uri = Uri.parse((String)(URI_STRING + context.getPackageName())).buildUpon().appendPath("pocConversion").build();
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            intent.putExtra("group", (Serializable)group);
            intent.putExtra("isCallMember", isCallMember);
            intent.putExtra(GroupConfig.GROUP_UI_POSITION, position);
            intent.putExtra("channel_name", channelName);
            context.startActivity(intent);
        }
        catch (Throwable e) {
            LogUtils.ELog((Throwable)e);
        }
    }

    public static void startPOCMainActivity(Context context, boolean isInitView) {
        try {
            if (context == null) {
                LogUtils.ELog((String)TAG, (String)"startPOCMainActivity context can't null");
                return;
            }
            Uri uri = Uri.parse((String)(URI_STRING + context.getPackageName())).buildUpon().appendPath("pocMain").build();
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            intent.putExtra("isInitView", isInitView);
            context.startActivity(intent);
        }
        catch (Throwable e) {
            LogUtils.ELog((Throwable)e);
        }
    }

    public static void startPOCMemberListActivity(Context context, int type) {
        try {
            if (context == null) {
                LogUtils.ELog((String)TAG, (String)"startPOCMainActivity context can't null");
                return;
            }
            Uri uri = Uri.parse((String)(URI_STRING + context.getPackageName())).buildUpon().appendPath("pocFriendList").build();
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            intent.putExtra("member_activity_type", type);
            context.startActivity(intent);
        }
        catch (Throwable e) {
            LogUtils.ELog((Throwable)e);
        }
    }

    public static void startPOCSettingActivity(Context context) {
        try {
            if (context == null) {
                LogUtils.ELog((String)TAG, (String)"context can't null");
                return;
            }
            Uri uri = Uri.parse((String)(URI_STRING + context.getPackageName())).buildUpon().appendPath("setting").build();
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            context.startActivity(intent);
        }
        catch (Exception e) {
            LogUtils.ELog((Throwable)e);
        }
    }

    public static void startLogin(Context context) {
        try {
            if (context == null) {
                LogUtils.ELog((String)TAG, (String)"context can't null");
                return;
            }
            Uri uri = Uri.parse((String)(URI_STRING + context.getPackageName())).buildUpon().appendPath("login").build();
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        }
        catch (Exception e) {
            LogUtils.ELog((Throwable)e);
        }
    }

    public static void startPOCCallWaitingActivity(Context context, POCCallMessage callMessage) {
        try {
            if (context == null) {
                LogUtils.ELog((String)TAG, (String)"context can't null");
                return;
            }
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            KeyguardManager.KeyguardLock keyguardLock = keyguardManager.newKeyguardLock("unLock");
            keyguardLock.reenableKeyguard();
            keyguardLock.disableKeyguard();
            Uri uri = Uri.parse((String)(URI_STRING + context.getPackageName())).buildUpon().appendPath("pocCallWaiting").build();
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            intent.putExtra(INTENT_KEY_CALL_WAITING_DATE, (Serializable)callMessage);
            intent.setFlags(0x10000000);
            context.startActivity(intent);
        }
        catch (Exception e) {
            LogUtils.ELog((Throwable)e);
        }
    }

    public static void startModifyPwd(Context context) {
        try {
            if (context == null) {
                LogUtils.ELog((String)TAG, (String)"context can't null");
                return;
            }
            Uri uri = Uri.parse((String)(URI_STRING + context.getPackageName())).buildUpon().appendPath("modifyPwd").build();
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            context.startActivity(intent);
        }
        catch (Exception e) {
            LogUtils.ELog((Throwable)e);
        }
    }

    public static void startRegister(Context context) {
        try {
            if (context == null) {
                LogUtils.ELog((String)TAG, (String)"context can't null");
                return;
            }
            Uri uri = Uri.parse((String)(URI_STRING + context.getPackageName())).buildUpon().appendPath("register").build();
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            context.startActivity(intent);
        }
        catch (Exception e) {
            LogUtils.ELog((Throwable)e);
        }
    }
}

